/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import computercraftsc.client.utils.MouseUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public abstract class Widget
extends AbstractGui {
    protected static final int LEFT_MOUSE_BTN = 0;
    protected static final int RIGHT_MOUSE_BTN = 1;
    protected static final int MIDDLE_MOUSE_BTN = 2;
    private Widget parent = null;
    private int inParentXPos;
    private int inParentYPos;
    private int width;
    private int height;
    private boolean isVisible = true;
    private int zLevel = 0;

    public Widget(int x, int y, int width, int height) {
        this.inParentXPos = x;
        this.inParentYPos = y;
        this.width = width;
        this.height = height;
    }

    public void setParent(Widget parent) {
        this.parent = parent;
    }

    public boolean isVisible() {
        return this.isVisible && (this.parent == null || this.parent.isVisible());
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public int getRelXPosition() {
        return this.inParentXPos;
    }

    public int getRelYPosition() {
        return this.inParentYPos;
    }

    public int getAbsoluteXPosition() {
        return this.inParentXPos + (this.parent != null ? this.parent.getAbsoluteXPosition() : 0);
    }

    public int getAbsoluteYPosition() {
        return this.inParentYPos + (this.parent != null ? this.parent.getAbsoluteYPosition() : 0);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public void setPosition(int x, int y) {
        this.inParentXPos = x;
        this.inParentYPos = y;
    }

    public void resize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void tick() {
    }

    public void draw(MatrixStack matrixStack, Minecraft mc, int xLeftTop, int yLeftTop, int mouseX, int mouseY) {
    }

    public void drawForeground(Minecraft mc, int xOrigin, int yOrigin, int mouseX, int mouseY) {
    }

    public void mouseMoved(int mouseX, int mouseY) {
    }

    public boolean mousePressed(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseReleased(int mouseX, int mouseY, int mouseButton) {
        return false;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollDelta) {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return false;
    }

    public boolean charTyped(char ch, int modifiers) {
        return false;
    }

    protected void drawFullImage(int x, int y, int w, int h) {
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        tessellator.func_178180_c().func_225582_a_((double)(x + 0), (double)(y + h), (double)this.zLevel).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + w), (double)(y + h), (double)this.zLevel).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + w), (double)(y + 0), (double)this.zLevel).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellator.func_178180_c().func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    protected void drawT3(MatrixStack matrixStack, int x, int y, int w, int h, int u, int v, int uw, int vh) {
        int partW = uw / 3;
        this.func_238474_b_(matrixStack, x, y, u, v, partW, vh);
        int middleBits = Math.max((w - 2 * partW) / partW, 0);
        for (int j = 0; j < middleBits; ++j) {
            this.func_238474_b_(matrixStack, x + (j + 1) * partW, y, u + partW, v, partW, vh);
        }
        int endW = w - (middleBits + 1) * partW;
        this.func_238474_b_(matrixStack, x + w - endW, y, u + uw - endW, v, endW, vh);
    }

    protected void drawT9(MatrixStack matrixStack, int x, int y, int w, int h, int u, int v, int uw, int vh) {
        int partH = vh / 3;
        this.drawT3(matrixStack, x, y, w, partH, u, v, uw, partH);
        int middleBits = Math.max((h - 2 * partH) / partH, 0);
        for (int j = 0; j < middleBits; ++j) {
            this.drawT3(matrixStack, x, y + (j + 1) * partH, w, partH, u, v + partH, uw, partH);
        }
        int endH = h - (middleBits + 1) * partH;
        this.drawT3(matrixStack, x, y + h - endH, w, endH, u, v + vh - endH, uw, endH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawInsetBorder(MatrixStack matrixStack, int x, int y, int w, int h) {
        try {
            this.func_238473_b_(matrixStack, x, y - 1, y + h - 1, -13224394);
            this.func_238473_b_(matrixStack, x + w - 1, y, y + h, -1);
            this.func_238465_a_(matrixStack, x, x + w - 2, y, -13224394);
            this.func_238465_a_(matrixStack, x + 1, x + w - 1, y + h - 1, -1);
            this.func_238465_a_(matrixStack, x, x, y + h - 1, -7697782);
            this.func_238465_a_(matrixStack, x + w - 1, x + w - 1, y, -7697782);
        }
        finally {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawString(MatrixStack matrixStack, String s, int x, int y, int color) {
        Minecraft mc = Minecraft.func_71410_x();
        try {
            mc.field_71466_p.func_238421_b_(matrixStack, s, (float)x, (float)y, color);
        }
        finally {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected int getStringWidth(String s) {
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71466_p.func_78256_a(s);
    }

    protected void playClickSound() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
    }

    protected boolean isMouseOnWidget() {
        MouseUtils.MousePos mousePos = MouseUtils.getMousePosition();
        double mouseX = mousePos.x;
        double mouseY = mousePos.y;
        return mouseX >= (double)this.getAbsoluteXPosition() && mouseX <= (double)(this.getAbsoluteXPosition() + this.getWidth()) && mouseY >= (double)this.getAbsoluteYPosition() && mouseY <= (double)(this.getAbsoluteYPosition() + this.getHeight());
    }
}

