/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.gui.widgets;

import computercraftsc.client.gui.widgets.TextAlignment;
import computercraftsc.client.gui.widgets.WidgetContainer;
import computercraftsc.client.gui.widgets.WidgetPopup;
import computercraftsc.client.gui.widgets.WidgetTextBox;
import computercraftsc.client.gui.widgets.WidgetTextButton;
import java.util.regex.Pattern;

public class WidgetTextEntryPopup
extends WidgetPopup {
    private static final Pattern SYMBOL_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9_]*");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("[0-9]+");
    private ITextEntryListener textEntryListener;
    private WidgetTextBox widgetTextBox;

    public WidgetTextEntryPopup(int x, int y, String defaultText, ITextEntryListener textEntryListener, final TextType type) {
        super(x, y, type == TextType.STRING ? 230 : 72, 18);
        this.textEntryListener = textEntryListener;
        WidgetContainer content = this.getContent();
        final WidgetTextButton okButton = new WidgetTextButton("gui.computercraftsc:popup_ok", content.getWidth() - 24, 0, 24, button -> this.tryConfirm());
        content.addWidget(okButton);
        this.widgetTextBox = new WidgetTextBox(defaultText, type == TextType.STRING ? 256 : 32, TextAlignment.LEFT, 0, 0, content.getWidth() - 24 - 2, new WidgetTextBox.ITextBoxListener(){

            @Override
            public void onTextChanged(WidgetTextBox widget) {
                okButton.setLocked(!widget.isTextValid());
            }

            @Override
            public void onFocusChanged(WidgetTextBox widget) {
            }

            @Override
            public boolean isTextValid(String text) {
                switch (type) {
                    case NUMBER: {
                        return !text.isEmpty() && text.length() <= 4 && NUMBER_PATTERN.matcher(text).matches();
                    }
                    case SYMBOL: {
                        return !text.isEmpty() && SYMBOL_PATTERN.matcher(text).matches();
                    }
                    case STRING: {
                        return true;
                    }
                }
                throw new Error("Unsupported text type: " + type.name());
            }
        });
        this.widgetTextBox.setFocus(true);
        okButton.setLocked(!this.widgetTextBox.isTextValid());
        content.addWidget(this.widgetTextBox);
    }

    public void setText(String text) {
        this.widgetTextBox.setText(text);
    }

    @Override
    protected void onCancel() {
        this.textEntryListener.onCancel(this);
    }

    @Override
    protected void onConfirm() {
        if (this.tryConfirm()) {
            this.playClickSound();
        }
    }

    private boolean tryConfirm() {
        if (this.widgetTextBox.isTextValid()) {
            this.textEntryListener.onConfirmation(this, this.widgetTextBox.getText());
            return true;
        }
        return false;
    }

    public static interface ITextEntryListener {
        public void onConfirmation(WidgetTextEntryPopup var1, String var2);

        public void onCancel(WidgetTextEntryPopup var1);
    }

    public static enum TextType {
        STRING,
        SYMBOL,
        NUMBER;

    }
}

