/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.client.network;

import computercraftsc.shared.network.packet.SetInventoriesLockStatePacket;
import computercraftsc.shared.network.packet.SetTurtleInventoryLockStatePacket;
import computercraftsc.shared.turtle.block.TileTurtleSC;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onSetTurtleInventoryLockStatePacketReceived(SetTurtleInventoryLockStatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.turtlePos);
        if (tileEntity instanceof TileTurtleSC) {
            ((TileTurtleSC)tileEntity).setTurtleInventoryLocked(packet.locked);
        }
    }

    public static void onSetInventoriesLockStatePacketReceived(SetInventoriesLockStatePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        TileEntity tileEntity = Minecraft.func_71410_x().field_71441_e.func_175625_s(packet.turtlePos);
        if (tileEntity instanceof TileTurtleSC) {
            ((TileTurtleSC)tileEntity).setInventoriesLocked(packet.locked);
        }
    }
}

