/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.event;

import computercraftsc.event.ProgramStateChangedEvent;
import computercraftsc.event.TurtleTeleportEvent;
import computercraftsc.event.listener.ProgramStateChangedEventListener;
import computercraftsc.event.listener.TurtleTeleportEventListener;
import java.util.ArrayList;
import java.util.List;

public class EventManager {
    private static final EventManager INSTANCE = new EventManager();
    private final List<TurtleTeleportEventListener> turtleTeleportEventListeners = new ArrayList<TurtleTeleportEventListener>();
    private final List<ProgramStateChangedEventListener> progStateChangedEventListeners = new ArrayList<ProgramStateChangedEventListener>();

    private EventManager() {
    }

    public static EventManager getInstance() {
        return INSTANCE;
    }

    public void addListener(TurtleTeleportEventListener listener) {
        this.turtleTeleportEventListeners.add(listener);
    }

    public void removeListener(TurtleTeleportEventListener listener) {
        this.turtleTeleportEventListeners.remove(listener);
    }

    public void addListener(ProgramStateChangedEventListener listener) {
        this.progStateChangedEventListeners.add(listener);
    }

    public void removeListener(ProgramStateChangedEventListener listener) {
        this.progStateChangedEventListeners.remove(listener);
    }

    public void fireTurtleTeleportEvent(TurtleTeleportEvent event) {
        for (TurtleTeleportEventListener listener : this.turtleTeleportEventListeners) {
            listener.onTurtleTeleport(event);
        }
    }

    public void fireProgStateChangedEvent(ProgramStateChangedEvent event) {
        for (ProgramStateChangedEventListener listener : this.progStateChangedEventListeners) {
            listener.onProgramStateChanged(event);
        }
    }
}

