/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.ast.BinaryOperator;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;

public class BinaryExpression
extends Expression {
    public BinaryOperator operator;
    public Expression leftExp;
    public Expression rightExp;

    public BinaryExpression(int codeStartIndex, int codeEndIndex, BinaryOperator operator, Expression leftExp, Expression rightExp) {
        super(codeStartIndex, codeEndIndex);
        this.operator = operator;
        this.leftExp = leftExp;
        this.rightExp = rightExp;
    }

    @Override
    public String toCodeString() {
        return this.leftExp.toCodeString() + " " + this.operator.getRepresentation() + " " + this.rightExp.toCodeString();
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.requireType(this.leftExp, this.operator.getLeftArgType(), compileExceptions);
        this.requireType(this.rightExp, this.operator.getRightArgType(), compileExceptions);
        return this.operator.getReturnType();
    }
}

