/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemBlockName;
import computercraftsc.shared.items.ItemItemName;
import computercraftsc.shared.items.ItemNumber;
import computercraftsc.shared.items.ItemString;
import computercraftsc.shared.items.ItemVariable;
import computercraftsc.shared.turtle.core.code.ast.ASTTerm;
import computercraftsc.shared.turtle.core.code.ast.BinaryExpression;
import computercraftsc.shared.turtle.core.code.ast.BinaryOperator;
import computercraftsc.shared.turtle.core.code.ast.BooleanConstant;
import computercraftsc.shared.turtle.core.code.ast.ExprFunctionType;
import computercraftsc.shared.turtle.core.code.ast.FunctionCallExpression;
import computercraftsc.shared.turtle.core.code.ast.IntegerConstant;
import computercraftsc.shared.turtle.core.code.ast.StringConstant;
import computercraftsc.shared.turtle.core.code.ast.UnaryExpression;
import computercraftsc.shared.turtle.core.code.ast.UnaryOperator;
import computercraftsc.shared.turtle.core.code.ast.Variable;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedASTTermSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.ItemStack;

public abstract class Expression
extends ASTTerm {
    public Expression(int codeStartIndex, int codeEndIndex) {
        super(codeStartIndex, codeEndIndex);
    }

    public static Expression parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        Expression rightExp;
        BinaryOperator operator;
        Expression exp = Expression.parseSimpleExp(code, codeIndex);
        ItemStack stack = Expression.getFirstNonNullItem(code, codeIndex);
        if (stack == null) {
            return exp;
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.OR.get()) {
            operator = BinaryOperator.OR;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.AND.get()) {
            operator = BinaryOperator.AND;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.EQUAL_TO.get()) {
            operator = BinaryOperator.EQUALS;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.NOT_EQUAL_TO.get()) {
            operator = BinaryOperator.NOT_EQUALS;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.LESS_THAN.get()) {
            operator = BinaryOperator.LT;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.LESS_THAN_OR_EQUAL_TO.get()) {
            operator = BinaryOperator.LTE;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.GREATER_THAN.get()) {
            operator = BinaryOperator.GT;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.GREATER_THAN_OR_EQUAL_TO.get()) {
            operator = BinaryOperator.GTE;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.PLUS.get()) {
            operator = BinaryOperator.PLUS;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.MINUS.get()) {
            operator = BinaryOperator.MINUS;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.TIMES.get()) {
            operator = BinaryOperator.TIMES;
        } else if (stack.func_77973_b() == RegistrySC.ModItems.DIVIDED_BY.get()) {
            operator = BinaryOperator.DIV;
        } else {
            return exp;
        }
        codeIndex.getAndIncrement();
        Expression otherExp = rightExp = Expression.parse(code, codeIndex);
        BinaryExpression prevOtherExp = null;
        while (otherExp instanceof BinaryExpression && operator.hasPrecedenceOver(((BinaryExpression)otherExp).operator)) {
            prevOtherExp = (BinaryExpression)otherExp;
            otherExp = prevOtherExp.leftExp;
        }
        if (prevOtherExp == null) {
            return new BinaryExpression(exp.getCodeStartIndex(), rightExp.getCodeEndIndex(), operator, exp, rightExp);
        }
        prevOtherExp.leftExp = new BinaryExpression(exp.getCodeStartIndex(), prevOtherExp.leftExp.getCodeEndIndex(), operator, exp, prevOtherExp.leftExp);
        return rightExp;
    }

    private static Expression parseSimpleExp(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack stack = Expression.getFirstNonNullItem(code, codeIndex);
        if (stack == null) {
            throw new ExpectedASTTermSyntaxException(Expression.class, codeIndex.get());
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.TRUE.get()) {
            return new BooleanConstant(codeIndex.getAndIncrement(), true);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.FALSE.get()) {
            return new BooleanConstant(codeIndex.getAndIncrement(), false);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.NUMBER.get()) {
            ItemNumber numberItem = (ItemNumber)stack.func_77973_b();
            return new IntegerConstant(codeIndex.getAndIncrement(), numberItem.getNumber(stack));
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.STRING.get()) {
            ItemString stringItem = (ItemString)stack.func_77973_b();
            return new StringConstant(codeIndex.getAndIncrement(), stringItem.getString(stack));
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.VARIABLE.get()) {
            ItemVariable variableItem = (ItemVariable)stack.func_77973_b();
            return new Variable(codeIndex.getAndIncrement(), variableItem.getName(stack));
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.NOT.get()) {
            int unExpIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parseSimpleExp(code, codeIndex);
            return new UnaryExpression(unExpIndex, exp.getCodeEndIndex(), UnaryOperator.NOT, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.PLUS.get()) {
            int unExpIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parseSimpleExp(code, codeIndex);
            return new UnaryExpression(unExpIndex, exp.getCodeEndIndex(), UnaryOperator.POSITIVE, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.MINUS.get()) {
            int unExpIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parseSimpleExp(code, codeIndex);
            return new UnaryExpression(unExpIndex, exp.getCodeEndIndex(), UnaryOperator.NEGATIVE, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.RANDOM_NUMBER.get()) {
            int randNumIndex = codeIndex.getAndIncrement();
            Expression exp = Expression.parseSimpleExp(code, codeIndex);
            return new FunctionCallExpression(randNumIndex, exp.getCodeEndIndex(), ExprFunctionType.RANDOM_NUMBER, exp);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.RANDOM_BOOLEAN.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.RANDOM_BOOL);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.GET_ITEM_COUNT.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.GET_ITEM_COUNT);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DETECT.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.DETECT);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DETECT_UP.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.DETECT_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.DETECT_DOWN.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.DETECT_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.COMPARE.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.COMPARE);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.COMPARE_UP.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.COMPARE_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.COMPARE_DOWN.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.COMPARE_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.INSPECT.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.INSPECT);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.INSPECT_UP.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.INSPECT_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.INSPECT_DOWN.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.INSPECT_DOWN);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.INSPECT_SLOT.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.INSPECT_SLOT);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.BLOCK.get()) {
            return new StringConstant(codeIndex.getAndIncrement(), ItemBlockName.getBlockName(stack));
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.ITEM.get()) {
            return new StringConstant(codeIndex.getAndIncrement(), ItemItemName.getItemName(stack));
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.QUERY_REDSTONE.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.QUERY_REDSTONE);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.QUERY_REDSTONE_UP.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.QUERY_REDSTONE_UP);
        }
        if (stack.func_77973_b() == RegistrySC.ModItems.QUERY_REDSTONE_DOWN.get()) {
            return new FunctionCallExpression(codeIndex.getAndIncrement(), ExprFunctionType.QUERY_REDSTONE_DOWN);
        }
        throw new ExpectedASTTermSyntaxException(Expression.class, codeIndex.get());
    }
}

