/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.RegistrySC;
import computercraftsc.shared.items.ItemProgrammingIcon;
import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.Statements;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.ExpectedItemSyntaxException;
import computercraftsc.shared.turtle.core.code.compiler.exception.SyntaxException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ForStatement
extends Statement {
    public String varName;
    public Expression startExp;
    public Expression endExp;
    public Statements codeStmts;

    public ForStatement(int codeStartIndex, int codeEndIndex, String varName, Expression startExp, Expression endExp, Statements codeStmts) {
        super(codeStartIndex, codeEndIndex);
        this.varName = varName;
        this.startExp = startExp;
        this.endExp = endExp;
        this.codeStmts = codeStmts;
    }

    public static ForStatement parse(List<ItemStack> code, AtomicInteger codeIndex) throws SyntaxException {
        ItemStack forStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (forStack == null || forStack.func_77973_b() != RegistrySC.ModItems.FOR.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.FOR.get(), codeIndex.get());
        }
        int forIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        ItemStack variableStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (variableStack == null || variableStack.func_77973_b() != RegistrySC.ModItems.VARIABLE.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.VARIABLE.get(), codeIndex.get());
        }
        String variableName = variableStack.func_82837_s() ? variableStack.func_200301_q().getString() : null;
        codeIndex.incrementAndGet();
        ItemStack equalsStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (equalsStack == null || equalsStack.func_77973_b() != RegistrySC.ModItems.EQUAL_TO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.EQUAL_TO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Expression startExp = Expression.parse(code, codeIndex);
        ItemStack toStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (toStack == null || toStack.func_77973_b() != RegistrySC.ModItems.TO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.TO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Expression endExp = Expression.parse(code, codeIndex);
        ItemStack doStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (doStack == null || doStack.func_77973_b() != RegistrySC.ModItems.DO.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.DO.get(), codeIndex.get());
        }
        codeIndex.incrementAndGet();
        Statements codeStmts = Statements.parse(code, codeIndex, (ItemProgrammingIcon)RegistrySC.ModItems.END.get());
        ItemStack endStack = ForStatement.getFirstNonNullItem(code, codeIndex);
        if (endStack == null || endStack.func_77973_b() != RegistrySC.ModItems.END.get()) {
            throw new ExpectedItemSyntaxException((Item)RegistrySC.ModItems.END.get(), codeIndex.get());
        }
        int endIndex = codeIndex.get();
        codeIndex.incrementAndGet();
        return new ForStatement(forIndex, endIndex, variableName, startExp, endExp, codeStmts);
    }

    @Override
    public String toCodeString() {
        return "for(" + this.varName + " = " + this.startExp.toCodeString() + " to " + this.endExp.toCodeString() + ") {\n\t" + this.codeStmts.toCodeString().replaceAll("\n", "\n\t") + "\n}";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        this.requireType(this.startExp, ClassType.INT, compileExceptions);
        this.requireType(this.endExp, ClassType.INT, compileExceptions);
        this.codeStmts.typecheck(compileExceptions);
        return ClassType.VOID;
    }
}

