/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.ast.Statement;
import computercraftsc.shared.turtle.core.code.ast.StmtFunctionType;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;

public class FunctionCallStatement
extends Statement {
    public StmtFunctionType function;
    public int callAmount;
    public Expression[] args;

    public FunctionCallStatement(int codeStartIndex, int codeEndIndex, StmtFunctionType function, int callAmount, Expression ... args) {
        super(codeStartIndex, codeEndIndex);
        this.function = function;
        this.callAmount = callAmount;
        this.args = args;
    }

    public FunctionCallStatement(int codeIndex, StmtFunctionType function, int callAmount) {
        this(codeIndex, codeIndex, function, callAmount, new Expression[0]);
    }

    public FunctionCallStatement(int codeStartIndex, int codeEndIndex, StmtFunctionType function, Expression ... args) {
        this(codeStartIndex, codeEndIndex, function, 1, args);
    }

    public FunctionCallStatement(int codeIndex, StmtFunctionType function) {
        this(codeIndex, codeIndex, function, 1, new Expression[0]);
    }

    @Override
    public String toCodeString() {
        String argsStr = this.args.length == 0 ? "" : this.args[0].toCodeString();
        for (int i = 1; i < this.args.length; ++i) {
            argsStr = argsStr + ", " + this.args[i].toCodeString();
        }
        String funcCallStr = this.function.getFuncName() + "(" + argsStr + ");";
        return this.callAmount == 1 ? funcCallStr : "repeat(" + this.callAmount + ") {\n\t" + funcCallStr + "\n}";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        if (this.function.hasArgument()) {
            this.requireType(this.args[0], this.function.getArgType(), compileExceptions);
        }
        return ClassType.VOID;
    }
}

