/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.ast;

import computercraftsc.shared.turtle.core.code.ast.Expression;
import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.compiler.exception.EmptyConstantException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import java.util.List;

public class StringConstant
extends Expression {
    public String value;

    public StringConstant(int codeIndex, String value) {
        super(codeIndex, codeIndex);
        this.value = value;
    }

    @Override
    public String toCodeString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public ClassType typecheck(List<CompileException> compileExceptions) {
        if (this.value == null) {
            compileExceptions.add(new EmptyConstantException(this.getCodeStartIndex()));
        }
        return ClassType.STRING;
    }
}

