/*
 * Decompiled with CFR 0.152.
 */
package computercraftsc.shared.turtle.core.code.compiler.exception;

import computercraftsc.shared.turtle.core.code.compiler.exception.CompileException;
import computercraftsc.shared.turtle.core.code.type.ClassType;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class TypeException
extends CompileException {
    private final ClassType expectedType;
    private final ClassType actualType;

    public TypeException(ClassType expectedType, ClassType actualType, int codeStartIndex, int codeEndIndex) {
        super(String.format("Expected type %s, but found type %s.", new Object[]{expectedType, actualType}), codeStartIndex, codeEndIndex);
        this.expectedType = expectedType;
        this.actualType = actualType;
    }

    public ClassType getExpectedType() {
        return this.expectedType;
    }

    public ClassType getActualType() {
        return this.actualType;
    }

    @Override
    public IFormattableTextComponent getTextComponent() {
        return new TranslationTextComponent("compiler.computercraftsc.type_exception_message__expected_type__actual_type", new Object[]{this.expectedType, this.actualType});
    }
}

