/*
 * Decompiled with CFR 0.152.
 */
package dialogs;

import dialogs.server.DialogManager;
import dialogs.shared.network.DialogsNetworkManager;
import java.io.File;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="dialogs")
public class DialogsMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "dialogs";
    public static final File MOD_CONFIG_DIR = new File("mods" + File.separator + "dialogs").getAbsoluteFile();
    public static final File NPC_TEXTURE_STORAGE_DIR = new File(MOD_CONFIG_DIR, "NPCTextures");
    private DialogManager dialogManager = null;
    public static DialogsMod instance;

    public DialogsMod() {
        instance = this;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(DialogsNetworkManager.class);
        modEventBus.addListener(this::serverSetup);
    }

    public DialogManager getDialogManager() {
        return this.dialogManager;
    }

    private void serverSetup(FMLDedicatedServerSetupEvent event) {
        if (!MOD_CONFIG_DIR.isDirectory() && !MOD_CONFIG_DIR.mkdirs()) {
            LOGGER.warn("Could not create mod config directory at: " + MOD_CONFIG_DIR.getAbsolutePath());
        }
        if (!NPC_TEXTURE_STORAGE_DIR.isDirectory() && !NPC_TEXTURE_STORAGE_DIR.mkdir()) {
            LOGGER.warn("Could not create texture storage directory at: " + NPC_TEXTURE_STORAGE_DIR.getAbsolutePath());
        }
        this.dialogManager = new DialogManager();
        MinecraftForge.EVENT_BUS.register((Object)this.dialogManager);
    }
}

