/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.network;

import dialogs.client.gui.screen.DialogScreen;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onOpenDialogPacketReceived(OpenDialogPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft.func_71410_x().func_147108_a((Screen)new DialogScreen(packet.dialogId, packet.npcTextureBytes, packet.dialogTitle, packet.dialogText, packet.dialogOptions));
    }

    public static void onCloseDialogPacketReceived(CloseDialogPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        if (Minecraft.func_71410_x().field_71462_r instanceof DialogScreen) {
            Minecraft.func_71410_x().field_71462_r.func_231175_as__();
        }
    }
}

