/*
 * Decompiled with CFR 0.152.
 */
package dialogs.server;

import dialogs.DialogsMod;
import dialogs.server.DialogOptionHandler;
import dialogs.server.DialogOptionHandlers;
import dialogs.shared.network.DialogsNetworkManager;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ServerPlayerEntity, DialogOptionHandlers> handlerMap = new HashMap<ServerPlayerEntity, DialogOptionHandlers>();
    private final Map<ServerPlayerEntity, Integer> dialogIdMap = new HashMap<ServerPlayerEntity, Integer>();
    private static final List<ITextComponent> CONTINUE_CLOSE_OPTION_LIST = Arrays.asList(new StringTextComponent("Continue"), new StringTextComponent("Close"));
    private static final int CONTINUE_OPTION_INDEX = 0;
    private static final int CLOSE_OPTION_INDEX = 1;

    public void showContinueCloseDialog(ServerPlayerEntity player, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) {
        this.showContinueCloseDialog(player, (File)null, dialogTitle, dialogText, continueOptionHandler, closeOptionHandler);
    }

    public void showContinueCloseDialog(ServerPlayerEntity player, String npcTextureResourceLocation, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) throws IllegalArgumentException {
        File npcTextureFile;
        if (npcTextureResourceLocation != null) {
            if (!npcTextureResourceLocation.matches("[a-zA-Z0-9\\-_]+(\\.[a-zA-Z0-9\\-_]+)*")) {
                throw new IllegalArgumentException("Invalid texture resource location: " + npcTextureResourceLocation);
            }
            npcTextureResourceLocation = npcTextureResourceLocation.replace('.', File.separatorChar) + ".png";
            npcTextureFile = new File(DialogsMod.NPC_TEXTURE_STORAGE_DIR.getAbsolutePath(), npcTextureResourceLocation);
        } else {
            npcTextureFile = null;
        }
        this.showContinueCloseDialog(player, npcTextureFile, dialogTitle, dialogText, continueOptionHandler, closeOptionHandler);
    }

    private void showContinueCloseDialog(ServerPlayerEntity player, File npcTextureFile, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) {
        byte[] npcTextureFileBytes = null;
        if (npcTextureFile != null) {
            if (!npcTextureFile.isFile()) {
                LOGGER.warn("NPC texture file does not exist or is not a file: " + npcTextureFile.getAbsolutePath());
            } else {
                try {
                    npcTextureFileBytes = FileUtils.readFileToByteArray((File)npcTextureFile);
                }
                catch (IOException e) {
                    LOGGER.warn("NPC texture file could not be read: " + npcTextureFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        this.handlerMap.put(player, new DialogOptionHandlers(continueOptionHandler, closeOptionHandler));
        int lastDialogId = this.dialogIdMap.getOrDefault(player, -1);
        int nextDialogId = lastDialogId + 1;
        this.dialogIdMap.put(player, nextDialogId);
        DialogsNetworkManager.sendPacketToPlayer(player, new OpenDialogPacket(nextDialogId, npcTextureFileBytes, dialogTitle, dialogText, CONTINUE_CLOSE_OPTION_LIST));
    }

    public void onDialogOptionActivated(ServerPlayerEntity player, int optionIndex) {
        DialogOptionHandler optionHandler;
        DialogOptionHandlers dialogOptionHandlers = this.handlerMap.get(player);
        if (dialogOptionHandlers == null) {
            return;
        }
        DialogOptionHandler dialogOptionHandler = optionIndex == 0 ? dialogOptionHandlers.getContinueOptionHandler() : (optionHandler = optionIndex == 1 ? dialogOptionHandlers.getCloseOptionHandler() : null);
        if (optionHandler != null) {
            optionHandler.onActivated(this, player);
        } else {
            this.closeDialog(player);
        }
    }

    public void closeDialog(ServerPlayerEntity player) {
        this.handlerMap.remove(player);
        DialogsNetworkManager.sendPacketToPlayer(player, new CloseDialogPacket());
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.handlerMap.remove(event.getPlayer());
        this.dialogIdMap.remove(event.getPlayer());
    }
}

