/*
 * Decompiled with CFR 0.152.
 */
package dialogs.server.network;

import dialogs.DialogsMod;
import dialogs.shared.network.packet.DialogOptionActivatedPacket;
import java.util.function.Supplier;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onDialogOptionActivatedPacketReceived(DialogOptionActivatedPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        DialogsMod.instance.getDialogManager().onDialogOptionActivated(ctx.getSender(), packet.optionIndex);
    }
}

