/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network;

import dialogs.client.network.ClientPacketHandler;
import dialogs.server.network.ServerPacketHandler;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.DialogOptionActivatedPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class DialogsNetworkManager {
    private static SimpleChannel channel;
    private static final String CHANNEL_ID = "dialogs";
    private static final String NETWORK_PROTOCOL_VERSION = "1";

    private DialogsNetworkManager() {
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(CHANNEL_ID, CHANNEL_ID), () -> NETWORK_PROTOCOL_VERSION, protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion), protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion));
        int packetId = 0;
        channel.registerMessage(packetId++, OpenDialogPacket.class, OpenDialogPacket::write, OpenDialogPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onOpenDialogPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, CloseDialogPacket.class, CloseDialogPacket::write, CloseDialogPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onCloseDialogPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, DialogOptionActivatedPacket.class, DialogOptionActivatedPacket::write, DialogOptionActivatedPacket::read, (packet, ctxSupplier) -> ServerPacketHandler.onDialogOptionActivatedPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <MSG> void sendPacketToServer(MSG packet) {
        channel.sendToServer(packet);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static <MSG> void sendPacketToPlayer(ServerPlayerEntity player, MSG packet) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

