/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client;

import dialogs.client.network.ClientPacketHandler;
import dialogs.client.playercontrol.AnimationInterpolationType;
import dialogs.client.playercontrol.PlayerFacingAnimator;
import dialogs.client.playercontrol.PlayerFacingExponentialInOutAnimator;
import dialogs.client.playercontrol.PlayerFacingLerpAnimator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class DialogsClient {
    private final Minecraft mc = Minecraft.func_71410_x();
    private PlayerFacingAnimator playerFacingAnimator = null;

    public DialogsClient(IEventBus eventBus) {
        eventBus.addListener(this::onClientSetup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientPacketHandler.init(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setPlayerFacingTarget(float yaw, float pitch, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        yaw = MathHelper.func_76142_g((float)yaw);
        pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        float currentYaw = MathHelper.func_76142_g((float)player.field_70177_z);
        float currentPitch = MathHelper.func_76131_a((float)player.field_70125_A, (float)-90.0f, (float)90.0f);
        float deltaYaw = yaw - currentYaw;
        if (deltaYaw > 180.0f) {
            deltaYaw -= 360.0f;
        } else if (deltaYaw < -180.0f) {
            deltaYaw += 360.0f;
        }
        float deltaPitch = pitch - currentPitch;
        switch (animationInterpolationType) {
            case EXPONENTIAL_IN_OUT: {
                this.playerFacingAnimator = new PlayerFacingExponentialInOutAnimator(currentYaw, deltaYaw, currentPitch, deltaPitch, System.currentTimeMillis(), durationMs, interpolationParam);
                break;
            }
            case LINEAR: {
                this.playerFacingAnimator = new PlayerFacingLerpAnimator(currentYaw, deltaYaw, currentPitch, deltaPitch, System.currentTimeMillis(), durationMs);
                break;
            }
            default: {
                throw new Error("Unsupported " + AnimationInterpolationType.class.getSimpleName() + ": " + animationInterpolationType.name());
            }
        }
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null || this.playerFacingAnimator == null) {
            return;
        }
        if (!this.playerFacingAnimator.apply(player, System.currentTimeMillis())) {
            this.playerFacingAnimator = null;
        }
    }
}

