/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenDialogPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final int dialogId;
    public final byte[] npcTextureBytes;
    public final ITextComponent dialogTitle;
    public final ITextComponent dialogText;
    public final List<ITextComponent> dialogOptions;

    public OpenDialogPacket(int dialogId, byte[] npcTextureBytes, ITextComponent dialogTitle, ITextComponent dialogText, List<ITextComponent> dialogOptions) {
        this.dialogId = dialogId;
        this.npcTextureBytes = npcTextureBytes == null ? new byte[]{} : npcTextureBytes;
        this.dialogTitle = dialogTitle;
        this.dialogText = dialogText;
        this.dialogOptions = dialogOptions == null ? Collections.emptyList() : dialogOptions;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.dialogId);
        buf.func_179250_a(this.npcTextureBytes);
        buf.func_179256_a(this.dialogTitle);
        buf.func_179256_a(this.dialogText);
        buf.writeInt(this.dialogOptions.size());
        for (int i = 0; i < this.dialogOptions.size(); ++i) {
            buf.func_179256_a(this.dialogOptions.get(i));
        }
    }

    public static OpenDialogPacket read(PacketBuffer buf) {
        try {
            int dialogId = buf.readInt();
            byte[] npcTextureBytes = buf.func_189425_b(Integer.MAX_VALUE);
            ITextComponent dialogTitle = buf.func_179258_d();
            ITextComponent dialogText = buf.func_179258_d();
            int numOptions = buf.readInt();
            ArrayList<ITextComponent> dialogOptions = new ArrayList<ITextComponent>(numOptions);
            for (int i = 0; i < numOptions; ++i) {
                dialogOptions.add(buf.func_179258_d());
            }
            return new OpenDialogPacket(dialogId, npcTextureBytes, dialogTitle, dialogText, dialogOptions);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + OpenDialogPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

