/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client;

import dialogs.client.gui.screen.InGameLoadingScreen;
import dialogs.client.network.ClientPacketHandler;
import dialogs.client.playercontrol.AnimationInterpolationType;
import dialogs.client.playercontrol.PlayerFacingAnimator;
import dialogs.client.playercontrol.PlayerFacingExponentialInOutAnimator;
import dialogs.client.playercontrol.PlayerFacingLerpAnimator;
import dialogs.client.playercontrol.PlayerPosAnimator;
import dialogs.client.playercontrol.PlayerPosExponentialInOutAnimator;
import dialogs.client.playercontrol.PlayerPosLerpAnimator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.network.play.server.SPlayerPositionLookPacket;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

public class DialogsClient {
    public static DialogsClient instance = null;
    private final Minecraft mc = Minecraft.func_71410_x();
    private PlayerFacingAnimator playerFacingAnimator = null;
    private PlayerPosAnimator playerPosAnimator = null;
    private float nightvisionBrightness = -1.0f;

    public DialogsClient(IEventBus eventBus) {
        instance = this;
        eventBus.addListener(this::onClientSetup);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ClientPacketHandler.init(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void setPlayerFacingTarget(float yaw, float pitch, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        yaw = MathHelper.func_76142_g((float)yaw);
        pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        float currentYaw = MathHelper.func_76142_g((float)player.field_70177_z);
        float currentPitch = MathHelper.func_76131_a((float)player.field_70125_A, (float)-90.0f, (float)90.0f);
        float deltaYaw = yaw - currentYaw;
        if (deltaYaw > 180.0f) {
            deltaYaw -= 360.0f;
        } else if (deltaYaw < -180.0f) {
            deltaYaw += 360.0f;
        }
        float deltaPitch = pitch - currentPitch;
        switch (animationInterpolationType) {
            case EXPONENTIAL_IN_OUT: {
                this.playerFacingAnimator = new PlayerFacingExponentialInOutAnimator(currentYaw, deltaYaw, currentPitch, deltaPitch, System.currentTimeMillis(), durationMs, interpolationParam);
                break;
            }
            case LINEAR: {
                this.playerFacingAnimator = new PlayerFacingLerpAnimator(currentYaw, deltaYaw, currentPitch, deltaPitch, System.currentTimeMillis(), durationMs);
                break;
            }
            default: {
                throw new Error("Unsupported " + AnimationInterpolationType.class.getSimpleName() + ": " + animationInterpolationType.name());
            }
        }
    }

    public void clearPlayerFacingTarget() {
        this.playerFacingAnimator = null;
    }

    public void setPlayerPosTarget(Vector3f targetPos, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        player.func_213293_j(0.0, 0.0, 0.0);
        switch (animationInterpolationType) {
            case EXPONENTIAL_IN_OUT: {
                this.playerPosAnimator = new PlayerPosExponentialInOutAnimator(new Vector3f(player.func_213303_ch()), targetPos, System.currentTimeMillis(), durationMs, interpolationParam);
                break;
            }
            case LINEAR: {
                this.playerPosAnimator = new PlayerPosLerpAnimator(new Vector3f(player.func_213303_ch()), targetPos, System.currentTimeMillis(), durationMs);
                break;
            }
            default: {
                throw new Error("Unsupported " + AnimationInterpolationType.class.getSimpleName() + ": " + animationInterpolationType.name());
            }
        }
    }

    public void clearPlayerPosTarget() {
        this.playerPosAnimator = null;
    }

    public void setNightvisionBrightness(float brightness) {
        this.nightvisionBrightness = brightness;
    }

    public float getNightvisionBrightness() {
        return this.nightvisionBrightness;
    }

    public void onSPlayerPositionLookPacketReceived(SPlayerPositionLookPacket packet) {
        this.playerPosAnimator = null;
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null || this.playerFacingAnimator == null) {
            return;
        }
        if (this.playerFacingAnimator != null && !this.playerFacingAnimator.apply(player, System.currentTimeMillis())) {
            this.playerFacingAnimator = null;
        }
    }

    @SubscribeEvent
    public void onPrePlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player == this.mc.field_71439_g && this.playerPosAnimator != null && !this.playerPosAnimator.apply((ClientPlayerEntity)event.player, System.currentTimeMillis())) {
            this.playerPosAnimator = null;
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        Screen currentScreen = this.mc.field_71462_r;
        if (currentScreen instanceof InGameLoadingScreen && !((InGameLoadingScreen)currentScreen).isScreenCloseAllowed()) {
            ((InGameLoadingScreen)currentScreen).setPreviousScreen(event.getGui());
            event.setGui(this.mc.field_71462_r);
        }
    }

    @SubscribeEvent
    public void onLoggedIn(ClientPlayerNetworkEvent.LoggedInEvent event) {
        this.setNightvisionBrightness(-1.0f);
    }

    @SubscribeEvent
    public void onLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.setNightvisionBrightness(-1.0f);
    }
}

