/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.gui.screen.accountmanagement;

import com.mojang.blaze3d.matrix.MatrixStack;
import dialogs.client.gui.screen.accountmanagement.AMLoginScreen;
import dialogs.client.gui.screen.accountmanagement.AMMainScreen;
import dialogs.client.gui.screen.accountmanagement.AbstractAMScreen;
import dialogs.client.gui.widget.TextFieldWidget;
import dialogs.shared.network.DialogsNetworkManager;
import dialogs.shared.network.packet.AMRegisterRequestPacket;
import dialogs.shared.network.packet.AMRegisterResponsePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;

public class AMRegisterScreen
extends AbstractAMScreen {
    private static final int TEMPELCODE_LOGO_OFFSET_X = 5;
    private static final int TEMPELCODE_LOGO_OFFSET_Y = 2;
    private static final float TEMPELCODE_LOGO_SCALE = 0.125f;
    private static final int TITLE_OFFSET_Y = 17;
    private static final int FONT_HEIGHT = 8;
    private static final int ERROR_TEXT_OFFSET_Y = 37;
    private static final int ERROR_TEXT_MIN_HORIZONTAL_SPACING = 5;
    private static final int USERNAME_TEXT_OFFSET_Y = 58;
    private static final int USERNAME_FIELD_OFFSET_Y = 69;
    private static final int USERNAME_FIELD_HEIGHT = 20;
    private static final int PASSWORD_TEXT_OFFSET_Y = 99;
    private static final int PASSWORD_FIELD_OFFSET_Y = 110;
    private static final int PASSWORD_FIELD_HEIGHT = 20;
    private static final int REPEAT_PASSWORD_TEXT_OFFSET_Y = 140;
    private static final int REPEAT_PASSWORD_FIELD_OFFSET_Y = 151;
    private static final int REPEAT_PASSWORD_FIELD_HEIGHT = 20;
    private static final int BUTTONS_OFFSET_Y = 181;
    private static final int CONTENT_WIDTH = 200;
    private static final int BUTTON_HEIGHT = 20;
    private static final ITextComponent USERNAME_TEXT = new TranslationTextComponent("gui.dialogs:accountmanagement.username");
    private static final ITextComponent PASSWORD_TEXT = new TranslationTextComponent("gui.dialogs:accountmanagement.password");
    private static final ITextComponent REPEAT_PASSWORD_TEXT = new TranslationTextComponent("gui.dialogs:accountmanagement.repeat_password");
    private ITextComponent errorMessage = null;
    private TextFieldWidget usernameField;
    private TextFieldWidget passwordField;
    private TextFieldWidget repeatPasswordField;
    private Button registerButton;
    private boolean registerRequestPending = false;

    public AMRegisterScreen(int maxUsernameChars, int maxPasswordChars) {
        super((ITextComponent)new TranslationTextComponent("gui.dialogs:accountmanagement.register_screen_title"), maxUsernameChars, maxPasswordChars);
    }

    @Override
    protected void func_231160_c_() {
        super.func_231160_c_();
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.usernameField = new TextFieldWidget(this.field_230712_o_, (this.field_230708_k_ - 200) / 2, 69, 200, 20, (ITextComponent)new StringTextComponent(""));
        this.func_212928_a((IGuiEventListener)this.usernameField);
        this.usernameField.func_146203_f(this.maxUsernameChars);
        this.usernameField.func_212954_a(text -> this.onTextFieldChanged());
        this.field_230705_e_.add(this.usernameField);
        this.passwordField = new TextFieldWidget(this.field_230712_o_, (this.field_230708_k_ - 200) / 2, 110, 200, 20, (ITextComponent)new StringTextComponent(""));
        this.passwordField.func_146203_f(this.maxPasswordChars);
        this.passwordField.func_212954_a(text -> this.onTextFieldChanged());
        this.passwordField.func_195607_a((text, lineScrollOffset) -> IReorderingProcessor.func_242239_a((String)text.replaceAll(".", "*"), (Style)Style.field_240709_b_));
        this.field_230705_e_.add(this.passwordField);
        this.repeatPasswordField = new TextFieldWidget(this.field_230712_o_, (this.field_230708_k_ - 200) / 2, 151, 200, 20, (ITextComponent)new StringTextComponent(""));
        this.repeatPasswordField.func_146203_f(this.maxPasswordChars);
        this.repeatPasswordField.func_212954_a(text -> this.onTextFieldChanged());
        this.repeatPasswordField.func_195607_a((text, lineScrollOffset) -> IReorderingProcessor.func_242239_a((String)text.replaceAll(".", "*"), (Style)Style.field_240709_b_));
        this.field_230705_e_.add(this.repeatPasswordField);
        int btnSpacing = 20;
        int btnWidth = (200 - btnSpacing) / 2;
        this.func_230480_a_((Widget)new Button((this.field_230708_k_ - 2 * btnWidth - btnSpacing) / 2, 181, btnWidth, 20, (ITextComponent)new TranslationTextComponent("gui.dialogs:accountmanagement.back"), button -> this.field_230706_i_.func_147108_a((Screen)new AMMainScreen(this.maxUsernameChars, this.maxPasswordChars).setClouds(this.getClouds()))));
        this.registerButton = (Button)this.func_230480_a_((Widget)new Button((this.field_230708_k_ + btnSpacing) / 2, 181, btnWidth, 20, (ITextComponent)new TranslationTextComponent("gui.dialogs:accountmanagement.register"), button -> this.onRegisterBtnPressed()));
        this.onTextFieldChanged();
    }

    private void onTextFieldChanged() {
        boolean passwordsMatch = this.passwordField.func_146179_b().equals(this.repeatPasswordField.func_146179_b());
        this.registerButton.field_230693_o_ = !this.usernameField.func_146179_b().isEmpty() && !this.passwordField.func_146179_b().isEmpty() && passwordsMatch;
        this.errorMessage = !passwordsMatch ? new TranslationTextComponent("gui.dialogs:accountmanagement.mismatching_repeat_password") : null;
    }

    private void onRegisterBtnPressed() {
        this.errorMessage = null;
        this.registerButton.field_230693_o_ = false;
        this.usernameField.field_230693_o_ = false;
        this.passwordField.field_230693_o_ = false;
        this.repeatPasswordField.field_230693_o_ = false;
        if (!this.registerRequestPending) {
            this.registerRequestPending = true;
            DialogsNetworkManager.sendPacketToServer(new AMRegisterRequestPacket(this.usernameField.func_146179_b(), this.passwordField.func_146179_b()));
        }
    }

    public void handleAMRegisterResponsePacket(AMRegisterResponsePacket packet) {
        this.usernameField.field_230693_o_ = true;
        this.passwordField.field_230693_o_ = true;
        this.repeatPasswordField.field_230693_o_ = true;
        this.onTextFieldChanged();
        if (packet.success) {
            this.field_230706_i_.func_147108_a((Screen)new AMLoginScreen(this.maxUsernameChars, this.maxPasswordChars).setClouds(this.getClouds()));
        } else {
            this.errorMessage = new StringTextComponent(packet.errorMessage);
        }
        this.registerRequestPending = false;
    }

    @Override
    public void func_231023_e_() {
        super.func_231023_e_();
        this.usernameField.func_146178_a();
        this.passwordField.func_146178_a();
        this.repeatPasswordField.func_146178_a();
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        ITextComponent errorMessage = this.errorMessage;
        String username = this.usernameField.func_146179_b();
        String password = this.passwordField.func_146179_b();
        String repeatPassword = this.repeatPasswordField.func_146179_b();
        this.func_231158_b_(minecraft, width, height);
        this.errorMessage = errorMessage;
        this.usernameField.func_146180_a(username);
        this.passwordField.func_146180_a(password);
        this.repeatPasswordField.func_146180_a(repeatPassword);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if ((keyCode == 257 || keyCode == 335) && this.registerButton.field_230693_o_) {
            this.onRegisterBtnPressed();
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        boolean handled = false;
        for (IGuiEventListener listener : this.func_231039_at__()) {
            if (listener.func_231044_a_(mouseX, mouseY, button)) {
                this.func_231035_a_(listener);
                if (button == 0) {
                    this.func_231037_b__(true);
                }
                handled = true;
                continue;
            }
            if (!(listener instanceof Widget) || !((Widget)listener).func_230999_j_()) continue;
            listener.func_231049_c__(false);
        }
        return handled;
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        AMRegisterScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_230712_o_, this.field_230704_d_, this.field_230708_k_ / 2, 17, 0xFFFFFF);
        if (this.errorMessage != null) {
            int errorMessageWidth = this.field_230712_o_.func_243245_a(this.errorMessage.func_241878_f());
            if (errorMessageWidth <= this.field_230708_k_ - 10) {
                AMRegisterScreen.drawCenteredStringWithoutShadow(matrixStack, this.field_230712_o_, this.errorMessage, this.field_230708_k_ / 2, 37, 0xAA0000);
            } else {
                this.field_230712_o_.func_238418_a_((ITextProperties)this.errorMessage, 5, 37, this.field_230708_k_, 0xAA0000);
            }
        }
        AMRegisterScreen.drawStringWithoutShadow(matrixStack, this.field_230712_o_, USERNAME_TEXT, (this.field_230708_k_ - 200) / 2, 58, 0x606060);
        AMRegisterScreen.drawStringWithoutShadow(matrixStack, this.field_230712_o_, PASSWORD_TEXT, (this.field_230708_k_ - 200) / 2, 99, 0x606060);
        AMRegisterScreen.drawStringWithoutShadow(matrixStack, this.field_230712_o_, REPEAT_PASSWORD_TEXT, (this.field_230708_k_ - 200) / 2, 140, 0x606060);
        this.usernameField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.passwordField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.repeatPasswordField.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected int getTempelCodeLogoX() {
        return 5;
    }

    @Override
    protected int getTempelCodeLogoY() {
        return 2;
    }

    @Override
    protected float getTempelCodeLogoScale() {
        return 0.125f;
    }

    public void func_231164_f_() {
        this.field_230706_i_.field_195559_v.func_197967_a(false);
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a((Screen)new AMMainScreen(this.maxUsernameChars, this.maxPasswordChars).setClouds(this.getClouds()));
    }
}

