/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.network;

import dialogs.client.DialogsClient;
import dialogs.client.gui.screen.DialogScreen;
import dialogs.client.gui.screen.InGameLoadingScreen;
import dialogs.client.gui.screen.accountmanagement.AMLoginScreen;
import dialogs.client.gui.screen.accountmanagement.AMMainScreen;
import dialogs.client.gui.screen.accountmanagement.AMRegisterScreen;
import dialogs.shared.network.packet.AMLoginResponsePacket;
import dialogs.shared.network.packet.AMRegisterResponsePacket;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.CloseLoadingScreenPacket;
import dialogs.shared.network.packet.OpenAMMainScreenPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import dialogs.shared.network.packet.OpenLoadingScreenPacket;
import dialogs.shared.network.packet.SetNightvisionBrightnessPacket;
import dialogs.shared.network.packet.SetPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.SetPlayerPosAnimationPacket;
import dialogs.shared.network.packet.StopPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.StopPlayerPosAnimationPacket;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();
    private static DialogsClient dialogsClient = null;

    public static void init(DialogsClient dialogsClient) {
        ClientPacketHandler.dialogsClient = dialogsClient;
    }

    public static void onOpenDialogPacketReceived(OpenDialogPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft.func_71410_x().func_147108_a((Screen)new DialogScreen(packet.dialogId, packet.npcTextureBytes, packet.textureCycleSpeedTicks, packet.dialogTitle, packet.dialogText, packet.dialogOptions));
    }

    public static void onCloseDialogPacketReceived(CloseDialogPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        if (Minecraft.func_71410_x().field_71462_r instanceof DialogScreen) {
            Minecraft.func_71410_x().field_71462_r.func_231175_as__();
        }
    }

    public static void onSetPlayerFacingAnimationPacketReceived(SetPlayerFacingAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        dialogsClient.setPlayerFacingTarget(packet.yaw, packet.pitch, packet.animationInterpolationType, packet.durationMs, packet.interpolationParam);
    }

    public static void onStopPlayerFacingAnimationPacketReceived(StopPlayerFacingAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        dialogsClient.clearPlayerFacingTarget();
    }

    public static void onSetPlayerPosAnimationPacketReceived(SetPlayerPosAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        dialogsClient.setPlayerPosTarget(packet.pos, packet.animationInterpolationType, packet.durationMs, packet.interpolationParam);
    }

    public static void onStopPlayerPosAnimationPacketReceived(StopPlayerPosAnimationPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        dialogsClient.clearPlayerPosTarget();
    }

    public static void onOpenLoadingScreenPacketReceived(OpenLoadingScreenPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new InGameLoadingScreen(packet.loadingText, packet.maxOpenTickCount, mc.field_71462_r instanceof InGameLoadingScreen ? ((InGameLoadingScreen)mc.field_71462_r).getPreviousScreen() : mc.field_71462_r));
    }

    public static void onCloseLoadingScreenPacketReceived(CloseLoadingScreenPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        if (Minecraft.func_71410_x().field_71462_r instanceof InGameLoadingScreen) {
            Minecraft.func_71410_x().field_71462_r.func_231175_as__();
        }
    }

    public static void onSetNightvisionBrightnessPacketReceived(SetNightvisionBrightnessPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        dialogsClient.setNightvisionBrightness(packet.getNightvisionBrightness());
    }

    public static void onOpenRegisterLoginMainScreenPacketReceived(OpenAMMainScreenPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft mc = Minecraft.func_71410_x();
        mc.func_147108_a((Screen)new AMMainScreen(packet.maxUsernameChars, packet.maxPasswordChars));
    }

    public static void onAMRegisterResponsePacketReceived(AMRegisterResponsePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof AMRegisterScreen) {
            ((AMRegisterScreen)mc.field_71462_r).handleAMRegisterResponsePacket(packet);
        }
    }

    public static void onAMLoginResponsePacketReceived(AMLoginResponsePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71462_r instanceof AMLoginScreen) {
            ((AMLoginScreen)mc.field_71462_r).handleAMLoginResponsePacket(packet);
        }
    }
}

