/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.playercontrol;

import dialogs.client.playercontrol.PlayerPosAnimator;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.util.math.vector.Vector3f;

public class PlayerPosExponentialInOutAnimator
extends PlayerPosAnimator {
    private final float exponent;

    public PlayerPosExponentialInOutAnimator(Vector3f startPos, Vector3f endPos, long startTimeMs, long durationMs, float exponent) {
        super(startPos, endPos, startTimeMs, durationMs);
        this.exponent = exponent;
    }

    @Override
    public boolean apply(ClientPlayerEntity player, long currentTimeMs) {
        long timeElapsedMs = currentTimeMs - this.startTimeMs;
        float progress = (float)timeElapsedMs / (float)this.durationMs;
        if (progress < 0.0f) {
            return false;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        float progressFirstHalf = (double)progress >= 0.5 ? 1.0f : (float)Math.pow(2.0f * progress, this.exponent);
        float progressSecondHalf = (double)progress < 0.5 ? 0.0f : 1.0f - (float)Math.pow(1.0 - 2.0 * ((double)progress - 0.5), this.exponent);
        float expFuncProgress = (progressFirstHalf + progressSecondHalf) / 2.0f;
        double x = this.startPos.func_195899_a() + (this.endPos.func_195899_a() - this.startPos.func_195899_a()) * expFuncProgress;
        double y = this.startPos.func_195900_b() + (this.endPos.func_195900_b() - this.startPos.func_195900_b()) * expFuncProgress;
        double z = this.startPos.func_195902_c() + (this.endPos.func_195902_c() - this.startPos.func_195902_c()) * expFuncProgress;
        if (progress < 1.0f) {
            player.func_213293_j(x - player.func_226277_ct_(), y - player.func_226278_cu_(), z - player.func_226281_cx_());
        } else {
            player.func_213293_j(0.0, 0.0, 0.0);
        }
        player.func_70107_b(x, y, z);
        return progress < 1.0f;
    }
}

