/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network;

import dialogs.client.network.ClientPacketHandler;
import dialogs.server.network.ServerPacketHandler;
import dialogs.shared.network.packet.AMLoginRequestPacket;
import dialogs.shared.network.packet.AMLoginResponsePacket;
import dialogs.shared.network.packet.AMRegisterRequestPacket;
import dialogs.shared.network.packet.AMRegisterResponsePacket;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.CloseLoadingScreenPacket;
import dialogs.shared.network.packet.DialogOptionActivatedPacket;
import dialogs.shared.network.packet.OpenAMMainScreenPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import dialogs.shared.network.packet.OpenLoadingScreenPacket;
import dialogs.shared.network.packet.SetNightvisionBrightnessPacket;
import dialogs.shared.network.packet.SetPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.SetPlayerPosAnimationPacket;
import dialogs.shared.network.packet.StopPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.StopPlayerPosAnimationPacket;
import java.util.Optional;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public abstract class DialogsNetworkManager {
    private static SimpleChannel channel;
    private static final String CHANNEL_ID = "dialogs";
    private static final String NETWORK_PROTOCOL_VERSION = "7";

    private DialogsNetworkManager() {
    }

    @SubscribeEvent
    public static void onCommonSetup(FMLCommonSetupEvent event) {
        channel = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation(CHANNEL_ID, CHANNEL_ID), () -> NETWORK_PROTOCOL_VERSION, protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion), protocolVersion -> NETWORK_PROTOCOL_VERSION.equals(protocolVersion));
        int packetId = 0;
        channel.registerMessage(packetId++, OpenDialogPacket.class, OpenDialogPacket::write, OpenDialogPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onOpenDialogPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, CloseDialogPacket.class, CloseDialogPacket::write, CloseDialogPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onCloseDialogPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, SetPlayerFacingAnimationPacket.class, SetPlayerFacingAnimationPacket::write, SetPlayerFacingAnimationPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onSetPlayerFacingAnimationPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, StopPlayerFacingAnimationPacket.class, StopPlayerFacingAnimationPacket::write, StopPlayerFacingAnimationPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onStopPlayerFacingAnimationPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, SetPlayerPosAnimationPacket.class, SetPlayerPosAnimationPacket::write, SetPlayerPosAnimationPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onSetPlayerPosAnimationPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, StopPlayerPosAnimationPacket.class, StopPlayerPosAnimationPacket::write, StopPlayerPosAnimationPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onStopPlayerPosAnimationPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, OpenLoadingScreenPacket.class, OpenLoadingScreenPacket::write, OpenLoadingScreenPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onOpenLoadingScreenPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, CloseLoadingScreenPacket.class, CloseLoadingScreenPacket::write, CloseLoadingScreenPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onCloseLoadingScreenPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, SetNightvisionBrightnessPacket.class, SetNightvisionBrightnessPacket::write, SetNightvisionBrightnessPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onSetNightvisionBrightnessPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, OpenAMMainScreenPacket.class, OpenAMMainScreenPacket::write, OpenAMMainScreenPacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onOpenRegisterLoginMainScreenPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, AMRegisterResponsePacket.class, AMRegisterResponsePacket::write, AMRegisterResponsePacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onAMRegisterResponsePacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, AMLoginResponsePacket.class, AMLoginResponsePacket::write, AMLoginResponsePacket::read, (packet, ctxSupplier) -> ClientPacketHandler.onAMLoginResponsePacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_CLIENT));
        channel.registerMessage(packetId++, DialogOptionActivatedPacket.class, DialogOptionActivatedPacket::write, DialogOptionActivatedPacket::read, (packet, ctxSupplier) -> ServerPacketHandler.onDialogOptionActivatedPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_SERVER));
        channel.registerMessage(packetId++, AMRegisterRequestPacket.class, AMRegisterRequestPacket::write, AMRegisterRequestPacket::read, (packet, ctxSupplier) -> ServerPacketHandler.onAMRegisterRequestPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_SERVER));
        channel.registerMessage(packetId++, AMLoginRequestPacket.class, AMLoginRequestPacket::write, AMLoginRequestPacket::read, (packet, ctxSupplier) -> ServerPacketHandler.onAMLoginRequestPacketReceived(packet, ctxSupplier), Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <MSG> void sendPacketToServer(MSG packet) {
        channel.sendToServer(packet);
    }

    @OnlyIn(value=Dist.DEDICATED_SERVER)
    public static <MSG> void sendPacketToPlayer(ServerPlayerEntity player, MSG packet) {
        channel.send(PacketDistributor.PLAYER.with(() -> player), packet);
    }
}

