/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogOptionActivatedPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final int dialogId;
    public final int optionIndex;

    public DialogOptionActivatedPacket(int dialogId, int optionIndex) {
        this.dialogId = dialogId;
        this.optionIndex = optionIndex;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.dialogId);
        buf.writeInt(this.optionIndex);
    }

    public static DialogOptionActivatedPacket read(PacketBuffer buf) {
        try {
            int dialogId = buf.readInt();
            int optionIndex = buf.readInt();
            return new DialogOptionActivatedPacket(dialogId, optionIndex);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + DialogOptionActivatedPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

