/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenLoadingScreenPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ITextComponent loadingText;
    public final int maxOpenTickCount;

    public OpenLoadingScreenPacket(ITextComponent loadingText, int maxOpenTickCount) {
        this.loadingText = loadingText;
        this.maxOpenTickCount = maxOpenTickCount;
    }

    public void write(PacketBuffer buf) {
        buf.func_179256_a(this.loadingText);
        buf.writeInt(this.maxOpenTickCount);
    }

    public static OpenLoadingScreenPacket read(PacketBuffer buf) {
        try {
            ITextComponent loadingText = buf.func_179258_d();
            int maxOpenTickCount = buf.readInt();
            return new OpenLoadingScreenPacket(loadingText, maxOpenTickCount);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + OpenLoadingScreenPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

