/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import dialogs.shared.network.DialogsNetworkManager;
import dialogs.shared.network.packet.DialogOptionActivatedPacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation DIALOG_TEXTURE_LOCATION = new ResourceLocation("dialogs", "textures/gui/dialog.png");
    private static final int DIALOG_TEXTURE_WIDTH = 320;
    private static final int DIALOG_TEXTURE_HEIGHT = 145;
    private static final int DIALOG_BOX_TEXTURE_OFFSET_X = 0;
    private static final int DIALOG_BOX_TEXTURE_OFFSET_Y = 0;
    private static final int DIALOG_BOX_TEXTURE_WIDTH = 320;
    private static final int DIALOG_BOX_TEXTURE_HEIGHT = 80;
    private static final int DIALOG_BOX_SPACING_BELOW = 5;
    private static final int CONTINUE_BTN_TEXTURE_OFFSET_X = 0;
    private static final int CONTINUE_BTN_TEXTURE_OFFSET_Y = 80;
    private static final int CONTINUE_BTN_TEXTURE_WIDTH = 16;
    private static final int CONTINUE_BTN_TEXTURE_HEIGHT = 16;
    private static final int CONTINUE_BTN_SPACING_RIGHT = 5;
    private static final int CONTINUE_BTN_SPACING_BOTTOM = 5;
    private static final int CLOSE_BTN_TEXTURE_OFFSET_X = 16;
    private static final int CLOSE_BTN_TEXTURE_OFFSET_Y = 80;
    private static final int CLOSE_BTN_TEXTURE_WIDTH = 16;
    private static final int CLOSE_BTN_TEXTURE_HEIGHT = 16;
    private static final int CLOSE_BTN_SPACING_TOP = 5;
    private static final int CLOSE_BTN_SPACING_RIGHT = 5;
    private static final int NPC_IMG_BACKGROUND_TEXTURE_OFFSET_X = 80;
    private static final int NPC_IMG_BACKGROUND_TEXTURE_OFFSET_Y = 80;
    private static final int NPC_IMG_BACKGROUND_TEXTURE_WIDTH = 53;
    private static final int NPC_IMG_BACKGROUND_TEXTURE_HEIGHT = 65;
    private static final int NPC_IMG_BACKGROUND_SPACING_TOP = 8;
    private static final int NPC_IMG_BACKGROUND_SPACING_LEFT = 10;
    private static final int NPC_IMG_TEXTURE_WIDTH = 49;
    private static final int NPC_IMG_TEXTURE_HEIGHT = 61;
    private static final int NPC_IMG_SPACING_TOP = 10;
    private static final int NPC_IMG_SPACING_LEFT = 12;
    private static final int TEXT_HEIGHT = 8;
    private static final int TITLE_SPACING_TOP = 8;
    private static final int TITLE_SPACING_LEFT = 10;
    private static final int MESSAGE_SPACING_TOP = 5;
    private static final int MESSAGE_SPACING_LEFT = 10;
    private static final int MESSAGE_MIN_SPACING_RIGHT = 6;
    public final int dialogId;
    private final ResourceLocation npcTextureLocation;
    private final ITextComponent dialogTitle;
    private final ITextComponent dialogMessage;
    private final List<ITextComponent> dialogOptions;
    private int continueOptionIndex = -1;
    private int closeOptionIndex = -1;
    private final int textureCycleSpeedTicks;
    private float textureCycleTimeTicks = 0.0f;
    private int textureFramesIndex = 0;
    private boolean continueHotkeyDown = false;
    private boolean closeScreenRequested = false;
    private boolean wasRenderCrosshairs;

    public DialogScreen(int dialogId, byte[] npcTextureBytes, int textureCycleSpeedTicks, ITextComponent dialogTitle, ITextComponent dialogMessage, List<ITextComponent> dialogOptions) {
        super((ITextComponent)new StringTextComponent("Dialog"));
        this.dialogId = dialogId;
        this.npcTextureLocation = npcTextureBytes == null || npcTextureBytes.length == 0 ? null : this.loadNpcTexture(npcTextureBytes);
        this.textureCycleSpeedTicks = textureCycleSpeedTicks;
        this.dialogTitle = dialogTitle;
        this.dialogMessage = dialogMessage;
        this.dialogOptions = dialogOptions;
    }

    private ResourceLocation loadNpcTexture(byte[] npcTextureBytes) {
        NativeImage img;
        try {
            img = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(npcTextureBytes));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load npc texture from received bytes.", (Throwable)e);
            return null;
        }
        return Minecraft.func_71410_x().func_110434_K().func_110578_a("dialog_npc", new DynamicTexture(img));
    }

    protected void func_231160_c_() {
        int x = 0;
        int y = 100;
        int width = 100;
        int height = 15;
        int spacing = 5;
        block8: for (int i = 0; i < this.dialogOptions.size(); ++i) {
            int dialogOptionIndex = i;
            ITextComponent dialogOptionText = this.dialogOptions.get(dialogOptionIndex);
            Button.IPressable btnPressListener = button -> this.handleDialogOptionPress(dialogOptionIndex);
            switch (dialogOptionText.getString().toLowerCase()) {
                case "continue": {
                    int btnX = (this.field_230708_k_ + 320) / 2 - 5 - 16;
                    int btnY = this.field_230709_l_ - 5 - 5 - 16;
                    this.func_230480_a_((Widget)new ImageButton(btnX, btnY, 16, 16, 0, 80, 16, DIALOG_TEXTURE_LOCATION, 320, 145, btnPressListener, (btn, matrixStack, mouseX, mouseY) -> GuiUtils.drawHoveringText((MatrixStack)matrixStack, Arrays.asList(new TranslationTextComponent("gui.dialogs:dialog_continue")), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_), StringTextComponent.field_240750_d_));
                    this.continueOptionIndex = dialogOptionIndex;
                    continue block8;
                }
                case "close": {
                    int btnX = (this.field_230708_k_ + 320) / 2 - 5 - 16;
                    int btnY = this.field_230709_l_ - 5 - 80 + 5;
                    this.func_230480_a_((Widget)new ImageButton(btnX, btnY, 16, 16, 16, 80, 16, DIALOG_TEXTURE_LOCATION, 320, 145, btnPressListener, (btn, matrixStack, mouseX, mouseY) -> GuiUtils.drawHoveringText((MatrixStack)matrixStack, Arrays.asList(new TranslationTextComponent("gui.dialogs:dialog_close")), (int)mouseX, (int)mouseY, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)-1, (FontRenderer)this.field_230712_o_), StringTextComponent.field_240750_d_));
                    this.closeOptionIndex = dialogOptionIndex;
                    continue block8;
                }
                default: {
                    this.func_230480_a_((Widget)new Button(x, y, width, height, dialogOptionText, btnPressListener));
                    x += width + spacing;
                }
            }
        }
        this.wasRenderCrosshairs = ForgeIngameGui.renderCrosshairs;
        ForgeIngameGui.renderCrosshairs = false;
    }

    public void func_231152_a_(Minecraft minecraft, int width, int height) {
        boolean wasRenderCrosshairs = this.wasRenderCrosshairs;
        this.func_231158_b_(minecraft, width, height);
        this.wasRenderCrosshairs = wasRenderCrosshairs;
    }

    private void handleDialogOptionPress(int optionIndex) {
        DialogsNetworkManager.sendPacketToServer(new DialogOptionActivatedPacket(this.dialogId, optionIndex));
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        if (this.npcTextureLocation != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_230706_i_.func_110434_K().func_110577_a(DIALOG_TEXTURE_LOCATION);
            int x = (this.field_230708_k_ - 320) / 2 + 10;
            int y = this.field_230709_l_ - 80 - 5 + 8;
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)80.0f, (float)80.0f, (int)53, (int)65, (int)320, (int)145);
            this.field_230706_i_.func_110434_K().func_110577_a(this.npcTextureLocation);
            DynamicTexture texture = (DynamicTexture)this.field_230706_i_.func_110434_K().func_229267_b_(this.npcTextureLocation);
            int numTextureFrames = texture.func_195414_e().func_195702_a() / 49;
            if (numTextureFrames > 1) {
                this.textureCycleTimeTicks += partialTicks;
                if (this.textureCycleTimeTicks > (float)this.textureCycleSpeedTicks) {
                    this.textureCycleTimeTicks -= (float)this.textureCycleSpeedTicks;
                    if (++this.textureFramesIndex >= numTextureFrames) {
                        this.textureFramesIndex = 0;
                    }
                }
            }
            x = (this.field_230708_k_ - 320) / 2 + 12;
            y = this.field_230709_l_ - 5 - 80 + 10;
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)(this.textureFramesIndex * 49), (float)0.0f, (int)49, (int)61, (int)texture.func_195414_e().func_195702_a(), (int)texture.func_195414_e().func_195714_b());
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        int titleX = (this.field_230708_k_ - 320) / 2 + 12 + 49 + 10;
        int titleY = this.field_230709_l_ - 5 - 80 + 8;
        int titleColor = -1;
        DialogScreen.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.dialogTitle, (int)titleX, (int)titleY, (int)titleColor);
        int messageX = titleX - 10 + 10;
        int messageY = titleY + 8 + 5;
        int maxTextWidth = 243;
        int messageColor = -16777216;
        this.field_230712_o_.func_238418_a_((ITextProperties)this.dialogMessage, messageX, messageY, maxTextWidth, messageColor);
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(DIALOG_TEXTURE_LOCATION);
        int x = (this.field_230708_k_ - 320) / 2;
        int y = this.field_230709_l_ - 80 - 5;
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)320, (int)80, (int)320, (int)145);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32 && this.continueOptionIndex >= 0) {
            this.continueHotkeyDown = true;
            this.handleDialogOptionPress(this.continueOptionIndex);
            return true;
        }
        if (keyCode == 256 && this.closeOptionIndex >= 0) {
            this.handleDialogOptionPress(this.closeOptionIndex);
            this.func_231175_as__();
            return true;
        }
        return this.func_241217_q_() != null && this.func_241217_q_().func_231046_a_(keyCode, scanCode, modifiers);
    }

    public boolean func_223281_a_(int keyCode, int scanCode, int modifiers) {
        if (this.continueHotkeyDown && keyCode == 32) {
            this.continueHotkeyDown = false;
            if (this.closeScreenRequested && Minecraft.func_71410_x().field_71462_r == this) {
                super.func_231175_as__();
            }
        }
        return super.func_223281_a_(keyCode, scanCode, modifiers);
    }

    public void func_231175_as__() {
        if (!this.continueHotkeyDown) {
            super.func_231175_as__();
        } else {
            this.closeScreenRequested = true;
        }
    }

    public void func_231164_f_() {
        Minecraft.func_71410_x().func_110434_K().func_147645_c(this.npcTextureLocation);
        ForgeIngameGui.renderCrosshairs = this.wasRenderCrosshairs;
    }
}

