/*
 * Decompiled with CFR 0.152.
 */
package dialogs.client.gui.screen.accountmanagement;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;

public abstract class AbstractAMScreen
extends Screen {
    private static final ResourceLocation BACKGROUND_TEXTURE_LOCATION = new ResourceLocation("dialogs", "textures/gui/accountmanagement/background.png");
    private static final ResourceLocation TILEABLE_PILLAR_TEXTURE_LOCATION = new ResourceLocation("dialogs", "textures/gui/accountmanagement/tileable_pillar.png");
    private static final int TILEABLE_PILLAR_TEXTURE_WIDTH = 64;
    private static final int TILEABLE_PILLAR_TEXTURE_HEIGHT = 80;
    private static final ResourceLocation[] CLOUD_TEXTURE_LOCATIONS = new ResourceLocation[]{new ResourceLocation("dialogs", "textures/gui/accountmanagement/cloud_1.png"), new ResourceLocation("dialogs", "textures/gui/accountmanagement/cloud_2.png"), new ResourceLocation("dialogs", "textures/gui/accountmanagement/cloud_3.png"), new ResourceLocation("dialogs", "textures/gui/accountmanagement/cloud_4.png"), new ResourceLocation("dialogs", "textures/gui/accountmanagement/cloud_5.png")};
    private static final int[] CLOUD_TEXTURE_WIDTHS = new int[]{23, 36, 36, 53, 40};
    private static final int[] CLOUD_TEXTURE_HEIGHTS = new int[]{10, 15, 17, 20, 15};
    private static final float CLOUD_SIZE_FACTOR = 2.0f;
    private static final float CLOUD_DISTANCE_PER_TICK = 5.0E-4f;
    private static final ResourceLocation TEMPELCODE_LOGO_TEXTURE_LOCATION = new ResourceLocation("dialogs", "textures/gui/accountmanagement/tempelcode_logo.png");
    private static final int TEMPELCODE_LOGO_TEXTURE_WIDTH = 483;
    private static final int TEMPELCODE_LOGO_TEXTURE_HEIGHT = 297;
    protected static final float TEMPELCODE_LOGO_DEFAULT_SCALE = 0.25f;
    private static final ResourceLocation SC_LOGO_TEXTURE_LOCATION = new ResourceLocation("dialogs", "textures/gui/accountmanagement/sc_logo.png");
    private static final int SC_LOGO_TEXTURE_WIDTH = 512;
    private static final int SC_LOGO_TEXTURE_HEIGHT = 128;
    protected static final int SC_LOGO_WIDTH = 128;
    protected static final int SC_LOGO_HEIGHT = 32;
    private List<Cloud> clouds = null;
    public final int maxUsernameChars;
    public final int maxPasswordChars;

    public AbstractAMScreen(ITextComponent title, int maxUsernameChars, int maxPasswordChars) {
        super(title);
        this.maxUsernameChars = maxUsernameChars;
        this.maxPasswordChars = maxPasswordChars;
    }

    public AbstractAMScreen setClouds(List<Cloud> clouds) {
        this.clouds = clouds;
        return this;
    }

    public List<Cloud> getClouds() {
        return this.clouds;
    }

    protected void func_231160_c_() {
        if (this.clouds == null) {
            this.clouds = this.createInitialCloudConfig();
        }
    }

    public List<Cloud> createInitialCloudConfig() {
        float[] initialXPercentage = new float[]{0.1f, 0.6f, 0.3f, 0.8f, 0.4f};
        float[] initialYPercentage = new float[]{0.2f, 0.4f, 0.5f, 0.6f, 0.8f};
        ArrayList<Cloud> ret = new ArrayList<Cloud>();
        for (int i = 0; i < CLOUD_TEXTURE_LOCATIONS.length; ++i) {
            ret.add(new Cloud(i, initialXPercentage[i], initialYPercentage[i]));
        }
        return ret;
    }

    public void func_231023_e_() {
        if (this.clouds != null) {
            for (Cloud cloud : this.clouds) {
                cloud.prevXPercentage = cloud.xPercentage;
                cloud.xPercentage += 5.0E-4f;
                if (!(cloud.xPercentage > 1.0f)) continue;
                cloud.prevXPercentage = 0.0f;
                cloud.xPercentage = 0.0f;
            }
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int logoX;
        int logoY;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        this.func_230446_a_(matrixStack);
        this.renderClouds(matrixStack, partialTicks);
        if (this.doRenderSCLogo()) {
            logoY = 0;
            logoX = this.field_230708_k_ - 128;
            this.field_230706_i_.field_71446_o.func_110577_a(SC_LOGO_TEXTURE_LOCATION);
            AbstractAMScreen.func_238463_a_((MatrixStack)matrixStack, (int)logoX, (int)logoY, (float)0.0f, (float)0.0f, (int)128, (int)32, (int)128, (int)32);
        }
        logoY = this.getTempelCodeLogoY();
        logoX = this.getTempelCodeLogoX();
        int logoWidth = (int)(483.0f * this.getTempelCodeLogoScale());
        int logoHeight = (int)(297.0f * this.getTempelCodeLogoScale());
        this.field_230706_i_.field_71446_o.func_110577_a(TEMPELCODE_LOGO_TEXTURE_LOCATION);
        AbstractAMScreen.func_238463_a_((MatrixStack)matrixStack, (int)logoX, (int)logoY, (float)0.0f, (float)0.0f, (int)logoWidth, (int)logoHeight, (int)logoWidth, (int)logoHeight);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    protected boolean doRenderSCLogo() {
        return true;
    }

    protected int getTempelCodeLogoX() {
        return (this.field_230708_k_ - (int)(483.0f * this.getTempelCodeLogoScale())) / 2;
    }

    protected int getTempelCodeLogoY() {
        int logoBtnSpacing = 5;
        return ((Widget)this.field_230710_m_.get((int)0)).field_230691_m_ - logoBtnSpacing - (int)(297.0f * this.getTempelCodeLogoScale());
    }

    protected float getTempelCodeLogoScale() {
        return 0.25f;
    }

    public void func_230446_a_(MatrixStack matrixStack) {
        this.field_230706_i_.field_71446_o.func_110577_a(BACKGROUND_TEXTURE_LOCATION);
        AbstractAMScreen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)this.field_230708_k_, (int)this.field_230709_l_);
        this.field_230706_i_.field_71446_o.func_110577_a(TILEABLE_PILLAR_TEXTURE_LOCATION);
        int pillarHeight = 80;
        int pillarY = this.field_230709_l_ - pillarHeight;
        AbstractAMScreen.func_238463_a_((MatrixStack)matrixStack, (int)0, (int)pillarY, (float)0.0f, (float)0.0f, (int)this.field_230708_k_, (int)pillarHeight, (int)64, (int)80);
    }

    public void renderClouds(MatrixStack matrixStack, float partialTicks) {
        if (this.clouds != null) {
            for (Cloud cloud : this.clouds) {
                this.renderCloud(matrixStack, cloud, partialTicks);
            }
        }
    }

    public void renderCloud(MatrixStack matrixStack, Cloud cloud, float partialTicks) {
        this.field_230706_i_.field_71446_o.func_110577_a(CLOUD_TEXTURE_LOCATIONS[cloud.type]);
        float cloudWidth = (float)CLOUD_TEXTURE_WIDTHS[cloud.type] * 2.0f;
        float cloudHeight = (float)CLOUD_TEXTURE_HEIGHTS[cloud.type] * 2.0f;
        float xPercentage = cloud.prevXPercentage + (cloud.xPercentage - cloud.prevXPercentage) * partialTicks;
        float x = xPercentage * ((float)this.field_230708_k_ + cloudWidth) - cloudWidth;
        float y = cloud.yPercentage * ((float)(this.field_230709_l_ - 80) - cloudHeight);
        AbstractAMScreen.blitFloat(matrixStack, x, y, 0.0f, 0.0f, cloudWidth, cloudHeight, cloudWidth, cloudHeight);
    }

    protected static void blitFloat(MatrixStack matrixStack, float x, float y, float uOffset, float vOffset, float width, float height, float textureWidth, float textureHeight) {
        AbstractAMScreen.innerBlitFloat(matrixStack, x, x + width, y, y + height, 0.0f, uOffset / textureWidth, (uOffset + width) / textureWidth, vOffset / textureHeight, (vOffset + height) / textureHeight);
    }

    private static void innerBlitFloat(MatrixStack matrixStack, float x1, float x2, float y1, float y2, float blitOffset, float minU, float maxU, float minV, float maxV) {
        Matrix4f mat4f = matrixStack.func_227866_c_().func_227870_a_();
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(mat4f, x1, y2, blitOffset).func_225583_a_(minU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(mat4f, x2, y2, blitOffset).func_225583_a_(maxU, maxV).func_181675_d();
        bufferbuilder.func_227888_a_(mat4f, x2, y1, blitOffset).func_225583_a_(maxU, minV).func_181675_d();
        bufferbuilder.func_227888_a_(mat4f, x1, y1, blitOffset).func_225583_a_(minU, minV).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    protected static void drawCenteredStringWithoutShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color);
    }

    protected static void drawCenteredStringWithoutShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, int x, int y, int color) {
        IReorderingProcessor iReorderingProcessor = text.func_241878_f();
        fontRenderer.func_243248_b(matrixStack, text, (float)(x - fontRenderer.func_243245_a(iReorderingProcessor) / 2), (float)y, color);
    }

    protected static void drawStringWithoutShadow(MatrixStack matrixStack, FontRenderer fontRenderer, String text, int x, int y, int color) {
        fontRenderer.func_238421_b_(matrixStack, text, (float)x, (float)y, color);
    }

    protected static void drawStringWithoutShadow(MatrixStack matrixStack, FontRenderer fontRenderer, ITextComponent text, int x, int y, int color) {
        fontRenderer.func_243248_b(matrixStack, text, (float)x, (float)y, color);
    }

    public static class Cloud {
        public int type;
        public float prevXPercentage;
        public float xPercentage;
        public float yPercentage;

        public Cloud(int type, float xPercentage, float yPercentage) {
            this.type = type;
            this.prevXPercentage = xPercentage;
            this.xPercentage = xPercentage;
            this.yPercentage = yPercentage;
        }
    }
}

