/*
 * Decompiled with CFR 0.152.
 */
package dialogs.server;

import dialogs.DialogsMod;
import dialogs.client.playercontrol.AnimationInterpolationType;
import dialogs.server.DialogOptionHandler;
import dialogs.server.DialogOptionHandlers;
import dialogs.shared.network.DialogsNetworkManager;
import dialogs.shared.network.packet.CloseDialogPacket;
import dialogs.shared.network.packet.CloseLoadingScreenPacket;
import dialogs.shared.network.packet.OpenAMMainScreenPacket;
import dialogs.shared.network.packet.OpenDialogPacket;
import dialogs.shared.network.packet.OpenLoadingScreenPacket;
import dialogs.shared.network.packet.SetNightvisionBrightnessPacket;
import dialogs.shared.network.packet.SetPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.SetPlayerPosAnimationPacket;
import dialogs.shared.network.packet.StopPlayerFacingAnimationPacket;
import dialogs.shared.network.packet.StopPlayerPosAnimationPacket;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Map<ServerPlayerEntity, DialogOptionHandlers> handlerMap = new HashMap<ServerPlayerEntity, DialogOptionHandlers>();
    private final Map<ServerPlayerEntity, Integer> dialogIdMap = new HashMap<ServerPlayerEntity, Integer>();
    private static final List<ITextComponent> CONTINUE_CLOSE_OPTION_LIST = Arrays.asList(new StringTextComponent("Continue"), new StringTextComponent("Close"));
    private static final int CONTINUE_OPTION_INDEX = 0;
    private static final int CLOSE_OPTION_INDEX = 1;
    private AccountRegisterLoginRequestHandler accountRegisterLoginRequestHandler = null;

    public AccountRegisterLoginRequestHandler getAccountRegisterLoginRequestHandler() {
        return this.accountRegisterLoginRequestHandler;
    }

    public void setAccountRegisterRequestHandler(AccountRegisterLoginRequestHandler handler) {
        this.accountRegisterLoginRequestHandler = handler;
    }

    public void showContinueCloseDialog(ServerPlayerEntity player, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) {
        this.showContinueCloseDialog(player, (File)null, 0, dialogTitle, dialogText, continueOptionHandler, closeOptionHandler);
    }

    public void showContinueCloseDialog(ServerPlayerEntity player, String npcTextureResourceLocation, int textureCycleSpeedTicks, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) throws IllegalArgumentException {
        File npcTextureFile;
        if (npcTextureResourceLocation != null) {
            if (!npcTextureResourceLocation.matches("[a-zA-Z0-9\\-_]+(\\.[a-zA-Z0-9\\-_]+)*")) {
                throw new IllegalArgumentException("Invalid texture resource location: " + npcTextureResourceLocation);
            }
            npcTextureResourceLocation = npcTextureResourceLocation.replace('.', File.separatorChar) + ".png";
            npcTextureFile = new File(DialogsMod.NPC_TEXTURE_STORAGE_DIR.getAbsolutePath(), npcTextureResourceLocation);
        } else {
            npcTextureFile = null;
        }
        this.showContinueCloseDialog(player, npcTextureFile, textureCycleSpeedTicks, dialogTitle, dialogText, continueOptionHandler, closeOptionHandler);
    }

    private void showContinueCloseDialog(ServerPlayerEntity player, File npcTextureFile, int textureCycleSpeedTicks, ITextComponent dialogTitle, ITextComponent dialogText, DialogOptionHandler continueOptionHandler, DialogOptionHandler closeOptionHandler) {
        byte[] npcTextureFileBytes = null;
        if (npcTextureFile != null) {
            if (!npcTextureFile.isFile()) {
                LOGGER.warn("NPC texture file does not exist or is not a file: " + npcTextureFile.getAbsolutePath());
            } else {
                try {
                    npcTextureFileBytes = FileUtils.readFileToByteArray((File)npcTextureFile);
                }
                catch (IOException e) {
                    LOGGER.warn("NPC texture file could not be read: " + npcTextureFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
        this.handlerMap.put(player, new DialogOptionHandlers(continueOptionHandler, closeOptionHandler));
        int lastDialogId = this.dialogIdMap.getOrDefault(player, -1);
        int nextDialogId = lastDialogId + 1;
        this.dialogIdMap.put(player, nextDialogId);
        DialogsNetworkManager.sendPacketToPlayer(player, new OpenDialogPacket(nextDialogId, npcTextureFileBytes, textureCycleSpeedTicks, dialogTitle, dialogText, CONTINUE_CLOSE_OPTION_LIST));
    }

    public void onDialogOptionActivated(ServerPlayerEntity player, int optionIndex) {
        DialogOptionHandler optionHandler;
        DialogOptionHandlers dialogOptionHandlers = this.handlerMap.get(player);
        if (dialogOptionHandlers == null) {
            return;
        }
        DialogOptionHandler dialogOptionHandler = optionIndex == 0 ? dialogOptionHandlers.getContinueOptionHandler() : (optionHandler = optionIndex == 1 ? dialogOptionHandlers.getCloseOptionHandler() : null);
        if (optionHandler != null) {
            optionHandler.onActivated(this, player);
        } else {
            this.closeDialog(player);
        }
    }

    public void closeDialog(ServerPlayerEntity player) {
        this.handlerMap.remove(player);
        DialogsNetworkManager.sendPacketToPlayer(player, new CloseDialogPacket());
    }

    public void animatePlayerFacingTarget(ServerPlayerEntity player, float yaw, float pitch, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        DialogsNetworkManager.sendPacketToPlayer(player, new SetPlayerFacingAnimationPacket(yaw, pitch, animationInterpolationType, durationMs, interpolationParam));
    }

    public void stopPlayerFacingAnimation(ServerPlayerEntity player) {
        DialogsNetworkManager.sendPacketToPlayer(player, new StopPlayerFacingAnimationPacket());
    }

    public void animatePlayerPositionTarget(ServerPlayerEntity player, Vector3f pos, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        Vector3d diff = new Vector3d(pos).func_178788_d(player.func_213303_ch());
        float numTicks = (float)durationMs / 50.0f;
        player.func_213293_j(diff.field_72450_a / (double)numTicks * 2.0, diff.field_72448_b / (double)numTicks * 2.0, diff.field_72449_c / (double)numTicks * 2.0);
        DialogsNetworkManager.sendPacketToPlayer(player, new SetPlayerPosAnimationPacket(pos, animationInterpolationType, durationMs, interpolationParam));
    }

    public void stopPlayerPositionAnimation(ServerPlayerEntity player) {
        DialogsNetworkManager.sendPacketToPlayer(player, new StopPlayerPosAnimationPacket());
    }

    public void showLoadingScreen(ServerPlayerEntity player, ITextComponent loadingText, int maxOpenTickCount) {
        DialogsNetworkManager.sendPacketToPlayer(player, new OpenLoadingScreenPacket(loadingText, maxOpenTickCount));
    }

    public void closeLoadingScreen(ServerPlayerEntity player) {
        DialogsNetworkManager.sendPacketToPlayer(player, new CloseLoadingScreenPacket());
    }

    public void showRegisterLoginMainScreen(ServerPlayerEntity player, int maxUsernameChars, int maxPasswordChars) {
        DialogsNetworkManager.sendPacketToPlayer(player, new OpenAMMainScreenPacket(maxUsernameChars, maxPasswordChars));
    }

    public void setNightvisionBrightness(ServerPlayerEntity player, float brightness) {
        DialogsNetworkManager.sendPacketToPlayer(player, new SetNightvisionBrightnessPacket(brightness));
    }

    @SubscribeEvent
    public void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        this.handlerMap.remove(event.getPlayer());
        this.dialogIdMap.remove(event.getPlayer());
    }

    public static interface AccountRegisterLoginRequestHandler {
        public String handleRegisterRequest(ServerPlayerEntity var1, String var2, String var3);

        public String handleLoginRequest(ServerPlayerEntity var1, String var2, String var3);
    }
}

