/*
 * Decompiled with CFR 0.152.
 */
package dialogs.server.network;

import dialogs.DialogsMod;
import dialogs.server.DialogManager;
import dialogs.shared.network.DialogsNetworkManager;
import dialogs.shared.network.packet.AMLoginRequestPacket;
import dialogs.shared.network.packet.AMLoginResponsePacket;
import dialogs.shared.network.packet.AMRegisterRequestPacket;
import dialogs.shared.network.packet.AMRegisterResponsePacket;
import dialogs.shared.network.packet.DialogOptionActivatedPacket;
import java.util.function.Supplier;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onDialogOptionActivatedPacketReceived(DialogOptionActivatedPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        DialogsMod.instance.getDialogManager().onDialogOptionActivated(ctx.getSender(), packet.optionIndex);
    }

    public static void onAMRegisterRequestPacketReceived(AMRegisterRequestPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        DialogManager.AccountRegisterLoginRequestHandler accountRegisterRequestHandler = DialogsMod.instance.getDialogManager().getAccountRegisterLoginRequestHandler();
        String result = accountRegisterRequestHandler != null ? accountRegisterRequestHandler.handleRegisterRequest(ctx.getSender(), packet.username, packet.password) : "No register handler set. Please contact a server administrator.";
        DialogsNetworkManager.sendPacketToPlayer(ctx.getSender(), new AMRegisterResponsePacket(result));
    }

    public static void onAMLoginRequestPacketReceived(AMLoginRequestPacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        DialogManager.AccountRegisterLoginRequestHandler accountLoginRequestHandler = DialogsMod.instance.getDialogManager().getAccountRegisterLoginRequestHandler();
        String result = accountLoginRequestHandler != null ? accountLoginRequestHandler.handleLoginRequest(ctx.getSender(), packet.username, packet.password) : "No login handler set. Please contact a server administrator.";
        DialogsNetworkManager.sendPacketToPlayer(ctx.getSender(), new AMLoginResponsePacket(result));
    }
}

