/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OpenAMMainScreenPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final int maxUsernameChars;
    public final int maxPasswordChars;

    public OpenAMMainScreenPacket(int maxUsernameChars, int maxPasswordChars) {
        this.maxUsernameChars = maxUsernameChars;
        this.maxPasswordChars = maxPasswordChars;
    }

    public void write(PacketBuffer buf) {
        buf.writeInt(this.maxUsernameChars);
        buf.writeInt(this.maxPasswordChars);
    }

    public static OpenAMMainScreenPacket read(PacketBuffer buf) {
        try {
            int maxUsernameChars = buf.readInt();
            int maxPasswordChars = buf.readInt();
            return new OpenAMMainScreenPacket(maxUsernameChars, maxPasswordChars);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + OpenAMMainScreenPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

