/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import dialogs.client.playercontrol.AnimationInterpolationType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetPlayerFacingAnimationPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final float yaw;
    public final float pitch;
    public final AnimationInterpolationType animationInterpolationType;
    public final long durationMs;
    public final float interpolationParam;

    public SetPlayerFacingAnimationPacket(float yaw, float pitch, AnimationInterpolationType animationInterpolationType, long durationMs) {
        this(yaw, pitch, animationInterpolationType, durationMs, Float.NaN);
    }

    public SetPlayerFacingAnimationPacket(float yaw, float pitch, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        this.yaw = MathHelper.func_76142_g((float)yaw);
        this.pitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f);
        this.animationInterpolationType = animationInterpolationType;
        this.durationMs = durationMs;
        this.interpolationParam = interpolationParam;
    }

    public void write(PacketBuffer buf) {
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.func_179249_a((Enum)this.animationInterpolationType);
        buf.writeLong(this.durationMs);
        buf.writeFloat(this.interpolationParam);
    }

    public static SetPlayerFacingAnimationPacket read(PacketBuffer buf) {
        try {
            float yaw = buf.readFloat();
            float pitch = buf.readFloat();
            AnimationInterpolationType animationInterpolationType = (AnimationInterpolationType)buf.func_179257_a(AnimationInterpolationType.class);
            long durationMs = buf.readLong();
            float interpolationParam = buf.readFloat();
            return new SetPlayerFacingAnimationPacket(yaw, pitch, animationInterpolationType, durationMs, interpolationParam);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + SetPlayerFacingAnimationPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

