/*
 * Decompiled with CFR 0.152.
 */
package dialogs.shared.network.packet;

import dialogs.client.playercontrol.AnimationInterpolationType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3f;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetPlayerPosAnimationPacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final Vector3f pos;
    public final AnimationInterpolationType animationInterpolationType;
    public final long durationMs;
    public final float interpolationParam;

    public SetPlayerPosAnimationPacket(Vector3f pos, AnimationInterpolationType animationInterpolationType, long durationMs) {
        this(pos, animationInterpolationType, durationMs, Float.NaN);
    }

    public SetPlayerPosAnimationPacket(Vector3f pos, AnimationInterpolationType animationInterpolationType, long durationMs, float interpolationParam) {
        this.pos = pos;
        this.animationInterpolationType = animationInterpolationType;
        this.durationMs = durationMs;
        this.interpolationParam = interpolationParam;
    }

    public void write(PacketBuffer buf) {
        buf.writeFloat(this.pos.func_195899_a());
        buf.writeFloat(this.pos.func_195900_b());
        buf.writeFloat(this.pos.func_195902_c());
        buf.func_179249_a((Enum)this.animationInterpolationType);
        buf.writeLong(this.durationMs);
        buf.writeFloat(this.interpolationParam);
    }

    public static SetPlayerPosAnimationPacket read(PacketBuffer buf) {
        try {
            Vector3f pos = new Vector3f(buf.readFloat(), buf.readFloat(), buf.readFloat());
            AnimationInterpolationType animationInterpolationType = (AnimationInterpolationType)buf.func_179257_a(AnimationInterpolationType.class);
            long durationMs = buf.readLong();
            float interpolationParam = buf.readFloat();
            return new SetPlayerPosAnimationPacket(pos, animationInterpolationType, durationMs, interpolationParam);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + SetPlayerPosAnimationPacket.class.getSimpleName() + " packet:", (Throwable)e);
            return null;
        }
    }
}

