/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.client;

import forgenpcs.shared.network.NetworkManager;
import forgenpcs.shared.network.packet.RequestTexturePacket;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DynamicTextureManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final long TEXTURE_REQUEST_TIMEOUT_MS = 60000L;
    private static final Map<ResourceLocation, Long> PENDING_TEXTURE_REQUEST_TIMES = new HashMap<ResourceLocation, Long>();

    private DynamicTextureManager() {
    }

    public static ResourceLocation getTextureResourceLocation(ResourceLocation desiredTextureLocation, ResourceLocation defaultTextureLocation) {
        if (Minecraft.func_71410_x().func_110434_K().func_229267_b_(desiredTextureLocation) != null || Minecraft.func_71410_x().func_195551_G().func_219533_b(desiredTextureLocation)) {
            return desiredTextureLocation;
        }
        if (!desiredTextureLocation.func_110624_b().equals("forgenpcs")) {
            return defaultTextureLocation;
        }
        long currentTime = System.currentTimeMillis();
        Long time = PENDING_TEXTURE_REQUEST_TIMES.get(desiredTextureLocation);
        if (time == null || currentTime - time > 60000L) {
            LOGGER.info("Requesting texture from server: " + desiredTextureLocation);
            NetworkManager.sendPacketToServer(new RequestTexturePacket(desiredTextureLocation.func_110623_a()));
            PENDING_TEXTURE_REQUEST_TIMES.put(desiredTextureLocation, currentTime);
        }
        return defaultTextureLocation;
    }
}

