/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.server.network;

import forgenpcs.ForgeNPCsMod;
import forgenpcs.shared.network.NetworkManager;
import forgenpcs.shared.network.packet.RequestTexturePacket;
import forgenpcs.shared.network.packet.TexturePacket;
import java.io.File;
import java.io.IOException;
import java.util.function.Supplier;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onRequestTexturePacketReceived(RequestTexturePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        byte[] textureBytes;
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.SERVER) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        String textureLocation = packet.textureLocation;
        if (!textureLocation.matches("[a-zA-Z0-9\\-_]+(\\.[a-zA-Z0-9\\-_]+)*")) {
            LOGGER.warn("Player " + ctxSupplier.get().getSender().func_200200_C_().getString() + " has sent " + packet.getClass().getSimpleName() + " packet with invalid texture location: " + textureLocation);
            return;
        }
        String textureFileLocation = textureLocation.replace('.', File.separatorChar) + ".png";
        File textureFile = new File(ForgeNPCsMod.TEXTURE_STORAGE_DIR.getAbsolutePath(), textureFileLocation);
        if (!textureFile.isFile()) {
            LOGGER.warn("Player " + ctxSupplier.get().getSender().func_200200_C_().getString() + " has requested unexisting texture: " + textureFileLocation);
            return;
        }
        try {
            textureBytes = FileUtils.readFileToByteArray((File)textureFile);
        }
        catch (IOException e) {
            LOGGER.warn("Exception while reading texture file for player " + ctxSupplier.get().getSender().func_200200_C_().getString() + ": " + textureFile.getAbsolutePath(), (Throwable)e);
            return;
        }
        NetworkManager.sendPacketToPlayer(ctxSupplier.get().getSender(), new TexturePacket(textureLocation, textureBytes));
    }
}

