/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.shared.entity.ai.goal;

import java.util.EnumSet;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.util.math.vector.Vector3d;

public class WalkToLocationGoal
extends Goal {
    private final MobEntity entity;
    private final double speed;
    private final Vector3d targetLocation;
    private final WalkToLocationCallback callback;
    private static final int MAX_INITIAL_NO_PATH_TICKS = 10;
    private static final int MAX_NO_PATH_TICKS = 10;
    private int noPathTicks;
    private boolean hasFoundInitialPath = false;
    private boolean hasReachedTarget = false;

    public WalkToLocationGoal(MobEntity entity, Vector3d targetLocation, double speed) {
        this(entity, targetLocation, speed, null);
    }

    public WalkToLocationGoal(MobEntity entity, Vector3d targetLocation, double speed, WalkToLocationCallback callback) {
        this.entity = entity;
        this.targetLocation = targetLocation;
        this.speed = speed;
        this.callback = callback;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public Vector3d getTargetLocation() {
        return this.targetLocation;
    }

    public double getSpeed() {
        return this.speed;
    }

    public boolean func_75250_a() {
        return !this.hasReachedTarget && this.targetLocation != null;
    }

    public void func_75249_e() {
        PathNavigator navigator = this.entity.func_70661_as();
        navigator.func_226335_a_(1000.0f);
        navigator.func_75484_a(navigator.func_225466_a(this.targetLocation.field_72450_a, this.targetLocation.field_72448_b, this.targetLocation.field_72449_c, 0), this.speed);
        this.hasFoundInitialPath = navigator.func_226337_n_();
        this.noPathTicks = 0;
    }

    public boolean func_75253_b() {
        return this.func_75250_a();
    }

    public void func_75246_d() {
        if (!this.hasReachedTarget && this.entity.func_70661_as().func_75500_f()) {
            this.entity.func_70661_as().func_75484_a(this.entity.func_70661_as().func_225466_a(this.targetLocation.field_72450_a, this.targetLocation.field_72448_b, this.targetLocation.field_72449_c, 0), this.speed);
            boolean hasFoundPath = this.entity.func_70661_as().func_226337_n_();
            if (this.entity.func_195048_a(this.targetLocation) <= 1.0) {
                this.teleportToTarget();
            } else if (!hasFoundPath) {
                ++this.noPathTicks;
                if (this.noPathTicks > (this.hasFoundInitialPath ? 10 : 10)) {
                    this.teleportToTarget();
                }
            } else {
                this.hasFoundInitialPath = true;
                this.noPathTicks = 0;
            }
        }
    }

    private void teleportToTarget() {
        this.entity.func_70661_as().func_75499_g();
        this.entity.func_70107_b(this.targetLocation.field_72450_a, this.targetLocation.field_72448_b, this.targetLocation.field_72449_c);
        this.hasReachedTarget = true;
        this.callPathFinishedCallback();
    }

    private void callPathFinishedCallback() {
        if (this.callback != null) {
            try {
                this.callback.onPathFinished();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public void func_75251_c() {
        this.entity.func_70661_as().func_75499_g();
    }

    public static interface WalkToLocationCallback {
        public void onPathFinished();
    }
}

