/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import forgenpcs.client.DynamicTextureManager;
import forgenpcs.client.renderer.entity.model.NPCArmorModel;
import forgenpcs.client.renderer.entity.model.NPCModel;
import forgenpcs.shared.entity.NPCEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;

public class RenderNPC
extends LivingRenderer<NPCEntity, NPCModel<NPCEntity>> {
    public RenderNPC(EntityRendererManager renderManager) {
        super(renderManager, new NPCModel(0.0f), 0.5f);
        this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, (BipedModel)new NPCArmorModel(0.5f), (BipedModel)new NPCArmorModel(1.0f)));
        this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
        this.func_177094_a((LayerRenderer)new ElytraLayer((IEntityRenderer)this));
    }

    public void render(NPCEntity npc, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        this.setModelVisibilities(npc);
        super.func_225623_a_((LivingEntity)npc, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public Vector3d getRenderOffset(NPCEntity npc, float partialTicks) {
        return npc.func_213453_ef() ? new Vector3d(0.0, -0.125, 0.0) : super.func_225627_b_((Entity)npc, partialTicks);
    }

    private void setModelVisibilities(NPCEntity npc) {
        NPCModel model = (NPCModel)this.func_217764_d();
        model.func_178719_a(true);
        model.field_178720_f.field_78806_j = true;
        model.bipedBodyWear.field_78806_j = true;
        model.bipedLeftLegwear.field_78806_j = true;
        model.bipedRightLegwear.field_78806_j = true;
        model.bipedLeftArmwear.field_78806_j = true;
        model.bipedRightArmwear.field_78806_j = true;
        model.field_228270_o_ = npc.func_225608_bj_();
        BipedModel.ArmPose bipedmodel$armpose = RenderNPC.getArmPose(npc, Hand.MAIN_HAND);
        BipedModel.ArmPose bipedmodel$armpose1 = RenderNPC.getArmPose(npc, Hand.OFF_HAND);
        if (bipedmodel$armpose.func_241657_a_()) {
            BipedModel.ArmPose armPose = bipedmodel$armpose1 = npc.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
        }
        if (npc.func_184591_cq() == HandSide.RIGHT) {
            model.field_187076_m = bipedmodel$armpose;
            model.field_187075_l = bipedmodel$armpose1;
        } else {
            model.field_187076_m = bipedmodel$armpose1;
            model.field_187075_l = bipedmodel$armpose;
        }
    }

    private static BipedModel.ArmPose getArmPose(NPCEntity npc, Hand hand) {
        ItemStack itemstack = npc.func_184586_b(hand);
        if (itemstack.func_190926_b()) {
            return BipedModel.ArmPose.EMPTY;
        }
        if (npc.func_184600_cs() == hand && npc.func_184605_cv() > 0) {
            UseAction useAction = itemstack.func_77975_n();
            if (useAction == UseAction.BLOCK) {
                return BipedModel.ArmPose.BLOCK;
            }
            if (useAction == UseAction.BOW) {
                return BipedModel.ArmPose.BOW_AND_ARROW;
            }
            if (useAction == UseAction.SPEAR) {
                return BipedModel.ArmPose.THROW_SPEAR;
            }
            if (useAction == UseAction.CROSSBOW && hand == npc.func_184600_cs()) {
                return BipedModel.ArmPose.CROSSBOW_CHARGE;
            }
        } else if (!npc.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
            return BipedModel.ArmPose.CROSSBOW_HOLD;
        }
        return BipedModel.ArmPose.ITEM;
    }

    public ResourceLocation getEntityTexture(NPCEntity npc) {
        return DynamicTextureManager.getTextureResourceLocation(npc.getEntityTexture(), NPCEntity.DEFAULT_NPC_TEXTURE);
    }

    protected void preRenderCallback(NPCEntity npc, MatrixStack matrixStack, float partialTickTime) {
        float scale = 0.9375f;
        matrixStack.func_227862_a_(scale, scale, scale);
    }

    protected void renderName(NPCEntity npc, ITextComponent displayName, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        matrixStack.func_227860_a_();
        if (displayName != null) {
            super.func_225629_a_((Entity)npc, displayName, matrixStack, buffer, packedLight);
        }
        matrixStack.func_227865_b_();
    }

    protected void applyRotations(NPCEntity npc, MatrixStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks) {
        float f = npc.func_205015_b(partialTicks);
        if (npc.func_184613_cA()) {
            super.func_225621_a_((LivingEntity)npc, matrixStack, ageInTicks, rotationYaw, partialTicks);
            float f1 = (float)npc.func_184599_cB() + partialTicks;
            float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!npc.func_204805_cN()) {
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - npc.field_70125_A)));
            }
            Vector3d vector3d = npc.func_70676_i(partialTicks);
            Vector3d vector3d1 = npc.func_213322_ci();
            double d0 = Entity.func_213296_b((Vector3d)vector3d1);
            double d1 = Entity.func_213296_b((Vector3d)vector3d);
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
            }
        } else if (f > 0.0f) {
            super.func_225621_a_((LivingEntity)npc, matrixStack, ageInTicks, rotationYaw, partialTicks);
            float f3 = npc.func_70090_H() ? -90.0f - npc.field_70125_A : -90.0f;
            float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
            if (npc.func_213314_bj()) {
                matrixStack.func_227861_a_(0.0, -1.0, (double)0.3f);
            }
        } else {
            super.func_225621_a_((LivingEntity)npc, matrixStack, ageInTicks, rotationYaw, partialTicks);
        }
    }
}

