/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.client.network;

import forgenpcs.shared.network.packet.TexturePacket;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPacketHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void onTexturePacketReceived(TexturePacket packet, Supplier<NetworkEvent.Context> ctxSupplier) {
        NativeImage img;
        NetworkEvent.Context ctx = ctxSupplier.get();
        if (ctx.getDirection().getReceptionSide() != LogicalSide.CLIENT) {
            LOGGER.warn(packet.getClass().getSimpleName() + " packet received on the wrong side: " + ctx.getDirection().getReceptionSide());
            return;
        }
        ctx.setPacketHandled(true);
        try {
            img = NativeImage.func_195713_a((InputStream)new ByteArrayInputStream(packet.textureBytes));
        }
        catch (IOException e) {
            LOGGER.warn("Failed to load texture from received bytes.", (Throwable)e);
            return;
        }
        ResourceLocation textureLocation = new ResourceLocation("forgenpcs", packet.textureLocation);
        Minecraft.func_71410_x().func_110434_K().func_229263_a_(textureLocation, (Texture)new DynamicTexture(img));
        LOGGER.info("Received texture from server: " + textureLocation);
    }
}

