/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.shared.network.packet;

import net.minecraft.network.PacketBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TexturePacket {
    private static final Logger LOGGER = LogManager.getLogger();
    public final String textureLocation;
    public final byte[] textureBytes;

    public TexturePacket(String textureLocation, byte[] textureBytes) {
        this.textureLocation = textureLocation;
        this.textureBytes = textureBytes == null ? new byte[]{} : textureBytes;
    }

    public void write(PacketBuffer buf) {
        buf.func_180714_a(this.textureLocation);
        buf.func_179250_a(this.textureBytes);
    }

    public static TexturePacket read(PacketBuffer buf) {
        try {
            String textureLocation = buf.func_218666_n();
            byte[] textureBytes = buf.func_189425_b(Integer.MAX_VALUE);
            return new TexturePacket(textureLocation, textureBytes);
        }
        catch (Exception e) {
            LOGGER.warn("Exception while reading " + TexturePacket.class.getSimpleName() + " packet: ", (Throwable)e);
            return null;
        }
    }
}

