/*
 * Decompiled with CFR 0.152.
 */
package forgenpcs.shared.entity;

import com.google.gson.JsonParseException;
import forgenpcs.shared.entity.ai.goal.WalkToLocationGoal;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierManager;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.HandSide;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.Rotations;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class NPCEntity
extends CreatureEntity {
    public static final String NPC_DEFAULT_TEXTURE_LOCATION = "forgenpcs:textures/entity/npc/steve.png";
    public static final ResourceLocation DEFAULT_NPC_TEXTURE = new ResourceLocation("forgenpcs:textures/entity/npc/steve.png");
    private static final Rotations DEFAULT_HEAD_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_BODY_ROTATION = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFTARM_ROTATION = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHTARM_ROTATION = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final Rotations DEFAULT_LEFTLEG_ROTATION = new Rotations(-1.0f, 0.0f, -1.0f);
    private static final Rotations DEFAULT_RIGHTLEG_ROTATION = new Rotations(1.0f, 0.0f, 1.0f);
    public static final DataParameter<Rotations> HEAD_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> BODY_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> LEFT_ARM_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> RIGHT_ARM_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> LEFT_LEG_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<Rotations> RIGHT_LEG_ROTATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187199_i);
    public static final DataParameter<String> TEXTURE_LOCATION = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    public static final ITextComponent DEFAULT_DISPLAY_NAME = null;
    public static final DataParameter<ITextComponent> DISPLAY_NAME = EntityDataManager.func_187226_a(NPCEntity.class, (IDataSerializer)DataSerializers.field_187195_e);
    private Rotations headRotation = DEFAULT_HEAD_ROTATION;
    private Rotations bodyRotation = DEFAULT_BODY_ROTATION;
    private Rotations leftArmRotation = DEFAULT_LEFTARM_ROTATION;
    private Rotations rightArmRotation = DEFAULT_RIGHTARM_ROTATION;
    private Rotations leftLegRotation = DEFAULT_LEFTLEG_ROTATION;
    private Rotations rightLegRotation = DEFAULT_RIGHTLEG_ROTATION;
    private AttributeModifierManager attributes = null;
    private final NonNullList<ItemStack> handItems = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private final NonNullList<ItemStack> armorItems = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    private ResourceLocation npcTexture = DEFAULT_NPC_TEXTURE;
    private ITextComponent displayName = DEFAULT_DISPLAY_NAME;
    private Goal lookAtPlayerGoal = null;
    private Goal lookRandomlyGoal = null;
    private Goal waterAvoidingRandomWalkingGoal = null;
    private double waterAvoidingRandomWalkingSpeed = -1.0;
    private Goal panicGoal = null;
    private double panicGoalSpeed = -1.0;
    private WalkToLocationGoal walkToLocationGoal = null;

    public NPCEntity(EntityType<? extends CreatureEntity> entityType, World world) {
        super(entityType, world);
        this.field_70138_W = 1.0f;
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    protected void func_184651_r() {
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        return false;
    }

    public void setLookAtPlayer(boolean lookAtPlayer) {
        if (lookAtPlayer && this.lookAtPlayerGoal == null) {
            this.lookAtPlayerGoal = new LookAtGoal((MobEntity)this, PlayerEntity.class, 10.0f, 1.0f){

                public boolean func_75253_b() {
                    return false;
                }
            };
            this.field_70714_bg.func_75776_a(1, this.lookAtPlayerGoal);
        } else if (!lookAtPlayer && this.lookAtPlayerGoal != null) {
            this.field_70714_bg.func_85156_a(this.lookAtPlayerGoal);
            this.lookAtPlayerGoal = null;
        }
    }

    public void setLookRandomly(boolean lookRandomly) {
        if (lookRandomly && this.lookRandomlyGoal == null) {
            this.lookRandomlyGoal = new LookRandomlyGoal((MobEntity)this);
            this.field_70714_bg.func_75776_a(1, this.lookRandomlyGoal);
        } else if (!lookRandomly && this.lookRandomlyGoal != null) {
            this.field_70714_bg.func_85156_a(this.lookRandomlyGoal);
            this.lookRandomlyGoal = null;
        }
    }

    public void setWaterAvoidingRandomWalking(double waterAvoidingRandomWalkingSpeed) {
        if (waterAvoidingRandomWalkingSpeed > 0.0 && this.waterAvoidingRandomWalkingGoal == null) {
            this.waterAvoidingRandomWalkingSpeed = waterAvoidingRandomWalkingSpeed;
            this.waterAvoidingRandomWalkingGoal = new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, waterAvoidingRandomWalkingSpeed);
            this.field_70714_bg.func_75776_a(1, this.waterAvoidingRandomWalkingGoal);
        } else if (waterAvoidingRandomWalkingSpeed <= 0.0 && this.waterAvoidingRandomWalkingGoal != null) {
            this.field_70714_bg.func_85156_a(this.waterAvoidingRandomWalkingGoal);
            this.waterAvoidingRandomWalkingSpeed = -1.0;
            this.waterAvoidingRandomWalkingGoal = null;
        }
    }

    public void setPanic(double movementSpeed) {
        if (movementSpeed > 0.0 && this.panicGoal == null) {
            this.panicGoalSpeed = movementSpeed;
            this.panicGoal = new PanicGoal(this, movementSpeed){

                public boolean func_75250_a() {
                    return this.func_190863_f();
                }
            };
            this.field_70714_bg.func_75776_a(1, this.panicGoal);
        } else if (movementSpeed <= 0.0 && this.panicGoal != null) {
            this.field_70714_bg.func_85156_a(this.panicGoal);
            this.panicGoalSpeed = -1.0;
            this.panicGoal = null;
        }
    }

    public void setWalkLocationTarget(double x, double y, double z, double speed) {
        this.setWalkLocationTarget(x, y, z, speed, null);
    }

    public void setWalkLocationTarget(double x, double y, double z, double speed, WalkToLocationGoal.WalkToLocationCallback callback) {
        if (this.walkToLocationGoal != null) {
            this.walkToLocationGoal.func_75251_c();
            this.field_70714_bg.func_85156_a((Goal)this.walkToLocationGoal);
            this.walkToLocationGoal = null;
        }
        if (speed > 0.0) {
            this.walkToLocationGoal = new WalkToLocationGoal((MobEntity)this, new Vector3d(x, y, z), speed, callback);
            this.field_70714_bg.func_75776_a(1, (Goal)this.walkToLocationGoal);
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(HEAD_ROTATION, (Object)DEFAULT_HEAD_ROTATION);
        this.field_70180_af.func_187214_a(BODY_ROTATION, (Object)DEFAULT_BODY_ROTATION);
        this.field_70180_af.func_187214_a(LEFT_ARM_ROTATION, (Object)DEFAULT_LEFTARM_ROTATION);
        this.field_70180_af.func_187214_a(RIGHT_ARM_ROTATION, (Object)DEFAULT_RIGHTARM_ROTATION);
        this.field_70180_af.func_187214_a(LEFT_LEG_ROTATION, (Object)DEFAULT_LEFTLEG_ROTATION);
        this.field_70180_af.func_187214_a(RIGHT_LEG_ROTATION, (Object)DEFAULT_RIGHTLEG_ROTATION);
        this.field_70180_af.func_187214_a(DISPLAY_NAME, (Object)DEFAULT_DISPLAY_NAME);
        this.field_70180_af.func_187214_a(TEXTURE_LOCATION, (Object)NPC_DEFAULT_TEXTURE_LOCATION);
    }

    public AttributeModifierManager func_233645_dx_() {
        if (this.attributes == null) {
            this.attributes = new AttributeModifierManager(NPCEntity.registerAttributes().func_233813_a_());
        }
        return this.attributes;
    }

    public Iterable<ItemStack> func_184214_aD() {
        return this.handItems;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return this.armorItems;
    }

    public ItemStack func_184582_a(EquipmentSlotType equipmentSlotType) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                return (ItemStack)this.handItems.get(equipmentSlotType.func_188454_b());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(equipmentSlotType.func_188454_b());
            }
        }
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType equipmentSlotType, ItemStack stack) {
        switch (equipmentSlotType.func_188453_a()) {
            case HAND: {
                this.handItems.set(equipmentSlotType.func_188454_b(), (Object)stack);
                break;
            }
            case ARMOR: {
                this.armorItems.set(equipmentSlotType.func_188454_b(), (Object)stack);
            }
        }
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public void setDisplayName(ITextComponent name) {
        this.displayName = name;
        this.field_70180_af.func_187227_b(DISPLAY_NAME, (Object)name);
    }

    public ITextComponent func_145748_c_() {
        return this.displayName;
    }

    public void setEntityTexture(ResourceLocation textureLocation) {
        this.npcTexture = textureLocation;
        this.field_70180_af.func_187227_b(TEXTURE_LOCATION, (Object)textureLocation.toString());
    }

    public ResourceLocation getEntityTexture() {
        return this.npcTexture;
    }

    private ResourceLocation getTextureResourceLocation(String textureLocation) throws ResourceLocationException {
        return textureLocation.indexOf(58) == -1 ? new ResourceLocation("forgenpcs", textureLocation) : new ResourceLocation(textureLocation);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        ListNBT armorItemsNBT = new ListNBT();
        for (Object itemstack : this.armorItems) {
            CompoundNBT itemNBT = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(itemNBT);
            }
            armorItemsNBT.add((Object)itemNBT);
        }
        compound.func_218657_a("ArmorItems", (INBT)armorItemsNBT);
        ListNBT handItemsNBT = new ListNBT();
        for (ItemStack itemstack : this.handItems) {
            CompoundNBT itemNBT = new CompoundNBT();
            if (!itemstack.func_190926_b()) {
                itemstack.func_77955_b(itemNBT);
            }
            handItemsNBT.add((Object)itemNBT);
        }
        compound.func_218657_a("HandItems", (INBT)handItemsNBT);
        CompoundNBT poseNBT = new CompoundNBT();
        if (!DEFAULT_HEAD_ROTATION.equals((Object)this.headRotation)) {
            poseNBT.func_218657_a("Head", (INBT)this.headRotation.func_179414_a());
        }
        if (!DEFAULT_BODY_ROTATION.equals((Object)this.bodyRotation)) {
            poseNBT.func_218657_a("Body", (INBT)this.bodyRotation.func_179414_a());
        }
        if (!DEFAULT_LEFTARM_ROTATION.equals((Object)this.leftArmRotation)) {
            poseNBT.func_218657_a("LeftArm", (INBT)this.leftArmRotation.func_179414_a());
        }
        if (!DEFAULT_RIGHTARM_ROTATION.equals((Object)this.rightArmRotation)) {
            poseNBT.func_218657_a("RightArm", (INBT)this.rightArmRotation.func_179414_a());
        }
        if (!DEFAULT_LEFTLEG_ROTATION.equals((Object)this.leftLegRotation)) {
            poseNBT.func_218657_a("LeftLeg", (INBT)this.leftLegRotation.func_179414_a());
        }
        if (!DEFAULT_RIGHTLEG_ROTATION.equals((Object)this.rightLegRotation)) {
            poseNBT.func_218657_a("RightLeg", (INBT)this.rightLegRotation.func_179414_a());
        }
        compound.func_218657_a("Pose", (INBT)poseNBT);
        if (this.displayName != null) {
            compound.func_74778_a("DisplayName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.displayName));
        }
        if (!this.npcTexture.equals((Object)DEFAULT_NPC_TEXTURE)) {
            compound.func_74778_a("Texture", this.npcTexture.toString());
        }
        compound.func_74757_a("Sneaking", this.func_225608_bj_());
        compound.func_74757_a("LookAtPlayer", this.lookAtPlayerGoal != null);
        compound.func_74757_a("LookRandomly", this.lookRandomlyGoal != null);
        if (this.waterAvoidingRandomWalkingSpeed >= 0.0) {
            compound.func_74780_a("WaterAvoidingRandomWalkingSpeed", this.waterAvoidingRandomWalkingSpeed);
        }
        if (this.panicGoalSpeed >= 0.0) {
            compound.func_74780_a("PanicSpeed", this.panicGoalSpeed);
        }
        if (this.walkToLocationGoal != null && this.walkToLocationGoal.getTargetLocation() != null) {
            CompoundNBT posNBT = new CompoundNBT();
            posNBT.func_74780_a("x", this.walkToLocationGoal.getTargetLocation().field_72450_a);
            posNBT.func_74780_a("y", this.walkToLocationGoal.getTargetLocation().field_72448_b);
            posNBT.func_74780_a("z", this.walkToLocationGoal.getTargetLocation().field_72449_c);
            posNBT.func_74780_a("speed", this.walkToLocationGoal.getSpeed());
            compound.func_218657_a("WalkToLocation", (INBT)posNBT);
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT poseNBT;
        ListNBT poseHeadNBT;
        int i;
        super.func_70037_a(compound);
        if (compound.func_150297_b("ArmorItems", 9)) {
            ListNBT armorItemsNBT = compound.func_150295_c("ArmorItems", 10);
            for (i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)armorItemsNBT.func_150305_b(i)));
            }
        }
        if (compound.func_150297_b("HandItems", 9)) {
            ListNBT handItemsNBT = compound.func_150295_c("HandItems", 10);
            for (i = 0; i < this.handItems.size(); ++i) {
                this.handItems.set(i, (Object)ItemStack.func_199557_a((CompoundNBT)handItemsNBT.func_150305_b(i)));
            }
        }
        this.setHeadRotation((poseHeadNBT = (poseNBT = compound.func_74775_l("Pose")).func_150295_c("Head", 5)).isEmpty() ? DEFAULT_HEAD_ROTATION : new Rotations(poseHeadNBT));
        ListNBT poseBodyNBT = poseNBT.func_150295_c("Body", 5);
        this.setBodyRotation(poseBodyNBT.isEmpty() ? DEFAULT_BODY_ROTATION : new Rotations(poseBodyNBT));
        ListNBT poseLeftArmNBT = poseNBT.func_150295_c("LeftArm", 5);
        this.setLeftArmRotation(poseLeftArmNBT.isEmpty() ? DEFAULT_LEFTARM_ROTATION : new Rotations(poseLeftArmNBT));
        ListNBT poseRightArmNBT = poseNBT.func_150295_c("RightArm", 5);
        this.setRightArmRotation(poseRightArmNBT.isEmpty() ? DEFAULT_RIGHTARM_ROTATION : new Rotations(poseRightArmNBT));
        ListNBT poseLeftLegNBT = poseNBT.func_150295_c("LeftLeg", 5);
        this.setLeftLegRotation(poseLeftLegNBT.isEmpty() ? DEFAULT_LEFTLEG_ROTATION : new Rotations(poseLeftLegNBT));
        ListNBT poseRightLegNBT = poseNBT.func_150295_c("RightLeg", 5);
        this.setRightLegRotation(poseRightLegNBT.isEmpty() ? DEFAULT_RIGHTLEG_ROTATION : new Rotations(poseRightLegNBT));
        if (compound.func_150297_b("DisplayName", 8)) {
            String displayNameJson = compound.func_74779_i("DisplayName");
            try {
                this.setDisplayName((ITextComponent)ITextComponent.Serializer.func_240643_a_((String)displayNameJson));
            }
            catch (JsonParseException e) {
                this.setDisplayName((ITextComponent)new StringTextComponent(displayNameJson));
            }
        }
        if (compound.func_150297_b("Texture", 8)) {
            try {
                this.setEntityTexture(this.getTextureResourceLocation(compound.func_74779_i("Texture")));
            }
            catch (ResourceLocationException e) {
                this.setEntityTexture(DEFAULT_NPC_TEXTURE);
            }
        }
        this.func_226284_e_(compound.func_150297_b("Sneaking", 1) && compound.func_74767_n("Sneaking"));
        this.setLookAtPlayer(compound.func_150297_b("LookAtPlayer", 1) && compound.func_74767_n("LookAtPlayer"));
        this.setLookRandomly(compound.func_150297_b("LookRandomly", 1) && compound.func_74767_n("LookRandomly"));
        this.setWaterAvoidingRandomWalking(compound.func_150297_b("WaterAvoidingRandomWalkingSpeed", 6) ? compound.func_74769_h("WaterAvoidingRandomWalkingSpeed") : -1.0);
        this.setPanic(compound.func_150297_b("PanicSpeed", 6) ? compound.func_74769_h("PanicSpeed") : -1.0);
        if (compound.func_150297_b("WalkToLocation", 10)) {
            CompoundNBT posNBT = compound.func_74775_l("WalkToLocation");
            this.setWalkLocationTarget(posNBT.func_74769_h("x"), posNBT.func_74769_h("y"), posNBT.func_74769_h("z"), posNBT.func_74769_h("speed"));
        }
    }

    public void setHeadRotation(Rotations vec) {
        this.headRotation = vec;
        this.field_70180_af.func_187227_b(HEAD_ROTATION, (Object)vec);
    }

    public void setBodyRotation(Rotations vec) {
        this.bodyRotation = vec;
        this.field_70180_af.func_187227_b(BODY_ROTATION, (Object)vec);
    }

    public void setLeftArmRotation(Rotations vec) {
        this.leftArmRotation = vec;
        this.field_70180_af.func_187227_b(LEFT_ARM_ROTATION, (Object)vec);
    }

    public void setRightArmRotation(Rotations vec) {
        this.rightArmRotation = vec;
        this.field_70180_af.func_187227_b(RIGHT_ARM_ROTATION, (Object)vec);
    }

    public void setLeftLegRotation(Rotations vec) {
        this.leftLegRotation = vec;
        this.field_70180_af.func_187227_b(LEFT_LEG_ROTATION, (Object)vec);
    }

    public void setRightLegRotation(Rotations vec) {
        this.rightLegRotation = vec;
        this.field_70180_af.func_187227_b(RIGHT_LEG_ROTATION, (Object)vec);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getHeadRotation() {
        return this.headRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getBodyRotation() {
        return this.bodyRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftArmRotation() {
        return this.leftArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightArmRotation() {
        return this.rightArmRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getLeftLegRotation() {
        return this.leftLegRotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rotations getRightLegRotation() {
        return this.rightLegRotation;
    }

    public void func_70071_h_() {
        ResourceLocation textureLocation;
        Rotations rightLegRotation;
        Rotations leftLegRotation;
        Rotations rightArmRotation;
        Rotations leftArmRotation;
        Rotations bodyRotation;
        super.func_70071_h_();
        Rotations headRotation = (Rotations)this.field_70180_af.func_187225_a(HEAD_ROTATION);
        if (!this.headRotation.equals((Object)headRotation)) {
            this.setHeadRotation(headRotation);
        }
        if (!this.bodyRotation.equals((Object)(bodyRotation = (Rotations)this.field_70180_af.func_187225_a(BODY_ROTATION)))) {
            this.setBodyRotation(bodyRotation);
        }
        if (!this.leftArmRotation.equals((Object)(leftArmRotation = (Rotations)this.field_70180_af.func_187225_a(LEFT_ARM_ROTATION)))) {
            this.setLeftArmRotation(leftArmRotation);
        }
        if (!this.rightArmRotation.equals((Object)(rightArmRotation = (Rotations)this.field_70180_af.func_187225_a(RIGHT_ARM_ROTATION)))) {
            this.setRightArmRotation(rightArmRotation);
        }
        if (!this.leftLegRotation.equals((Object)(leftLegRotation = (Rotations)this.field_70180_af.func_187225_a(LEFT_LEG_ROTATION)))) {
            this.setLeftLegRotation(leftLegRotation);
        }
        if (!this.rightLegRotation.equals((Object)(rightLegRotation = (Rotations)this.field_70180_af.func_187225_a(RIGHT_LEG_ROTATION)))) {
            this.setRightLegRotation(rightLegRotation);
        }
        ITextComponent displayName = (ITextComponent)this.field_70180_af.func_187225_a(DISPLAY_NAME);
        if (this.displayName != null && !this.displayName.equals(displayName) || this.displayName == null && displayName != null) {
            this.setDisplayName(displayName);
        }
        String textureLocationStr = (String)this.field_70180_af.func_187225_a(TEXTURE_LOCATION);
        try {
            textureLocation = this.getTextureResourceLocation(textureLocationStr);
        }
        catch (ResourceLocationException e) {
            textureLocation = DEFAULT_NPC_TEXTURE;
        }
        if (!this.npcTexture.equals((Object)textureLocation)) {
            this.setEntityTexture(textureLocation);
        }
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.func_70104_M()) {
            super.func_82167_n(entityIn);
        }
    }
}

