/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer.actions;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.actions.Action;
import net.minecraftforge.installer.actions.ActionCanceledException;
import net.minecraftforge.installer.actions.ProgressCallback;
import net.minecraftforge.installer.json.InstallV1;
import net.minecraftforge.installer.json.Mod;
import net.minecraftforge.installer.json.Util;
import net.minecraftforge.installer.json.Version;

public class ClientInstall
extends Action {
    public ClientInstall(InstallV1 profile, ProgressCallback monitor) {
        super(profile, monitor, true);
    }

    @Override
    public boolean run(File target, Predicate<String> optionals, File installer) throws ActionCanceledException {
        if (!target.exists()) {
            this.error("There is no minecraft installation at: " + target);
            return false;
        }
        File launcherProfiles = new File(target, "launcher_profiles.json");
        File launcherProfilesMS = new File(target, "launcher_profiles_microsoft_store.json");
        if (!launcherProfiles.exists() && !launcherProfilesMS.exists()) {
            this.error("There is no minecraft launcher profile in \"" + target + "\", you need to run the launcher first!");
            return false;
        }
        File versionRoot = new File(target, "versions");
        File librariesDir = new File(target, "libraries");
        librariesDir.mkdir();
        this.checkCancel();
        this.monitor.stage("Extracting json");
        try (InputStream stream = Util.class.getResourceAsStream(this.profile.getJson());){
            File json = new File(versionRoot, this.profile.getVersion() + '/' + this.profile.getVersion() + ".json");
            json.getParentFile().mkdirs();
            Files.copy(stream, json.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            this.error("  Failed to extract");
            e.printStackTrace();
            return false;
        }
        this.checkCancel();
        this.monitor.stage("Considering minecraft client jar");
        File versionVanilla = new File(versionRoot, this.profile.getMinecraft());
        if (!versionVanilla.mkdirs() && !versionVanilla.isDirectory()) {
            if (!versionVanilla.delete()) {
                this.error("There was a problem with the launcher version data. You will need to clear " + versionVanilla + " manually.");
                return false;
            }
            versionVanilla.mkdirs();
        }
        this.checkCancel();
        File clientTarget = new File(versionVanilla, this.profile.getMinecraft() + ".jar");
        if (!clientTarget.exists()) {
            File versionJson = new File(versionVanilla, this.profile.getMinecraft() + ".json");
            Version vanilla = Util.getVanillaVersion(this.profile.getMinecraft(), versionJson);
            if (vanilla == null) {
                this.error("Failed to download version manifest, can not find client jar URL.");
                return false;
            }
            Version.Download client = vanilla.getDownload("client");
            if (client == null) {
                this.error("Failed to download minecraft client, info missing from manifest: " + versionJson);
                return false;
            }
            if (!DownloadUtils.download(this.monitor, this.profile.getMirror(), client, clientTarget)) {
                clientTarget.delete();
                this.error("Downloading minecraft client failed, invalid checksum.\nTry again, or use the vanilla launcher to install the vanilla version.");
                return false;
            }
        }
        if (!this.downloadLibraries(librariesDir, optionals, new ArrayList<File>())) {
            return false;
        }
        this.checkCancel();
        if (!this.processors.process(librariesDir, clientTarget, target, installer)) {
            return false;
        }
        this.checkCancel();
        this.monitor.stage("Injecting profile");
        if (launcherProfiles.exists() && !this.injectProfile(launcherProfiles)) {
            return false;
        }
        if (launcherProfilesMS.exists() && !this.injectProfile(launcherProfilesMS)) {
            return false;
        }
        Mod[] mods = this.profile.getMods();
        if (mods.length > 0) {
            File modsDir = new File(target, "mods");
            if (!modsDir.isDirectory()) {
                modsDir.mkdir();
            }
            for (Mod mod : mods) {
                File modFile = new File(modsDir, mod.getName() + ".jar");
                InputStream inStream = null;
                if (mod.getPath().startsWith("http://") || mod.getPath().startsWith("https://")) {
                    try {
                        URL url = new URL(mod.getPath());
                        URLConnection con = url.openConnection();
                        con.setConnectTimeout(5000);
                        con.setReadTimeout(5000);
                        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0");
                        inStream = con.getInputStream();
                    }
                    catch (MalformedURLException e) {
                        this.error("Invalid URL format in installer configuration for mod: " + mod.getName() + ", url: " + mod.getPath());
                        return false;
                    }
                    catch (IOException e) {
                        this.error("Unable to download mod: " + mod.getName() + ", url: " + mod.getPath());
                        return false;
                    }
                } else {
                    inStream = ClientInstall.class.getResourceAsStream(mod.getPath());
                    if (inStream == null) {
                        this.error("Mod missing in installer jar: " + mod.getName() + ", path: " + mod.getPath());
                        return false;
                    }
                }
                try {
                    int amount;
                    FileOutputStream outStream = new FileOutputStream(modFile);
                    byte[] buffer = new byte[8192];
                    while ((amount = inStream.read(buffer)) > 0) {
                        outStream.write(buffer, 0, amount);
                    }
                    inStream.close();
                    outStream.close();
                }
                catch (IOException e) {
                    this.error("There was an error while installing mod: " + mod.getName() + ". Details: " + e.getClass().getSimpleName() + " - " + e.getMessage());
                    return false;
                }
            }
        }
        return true;
    }

    private boolean injectProfile(File target) {
        try {
            JsonObject _profile;
            JsonObject json = null;
            try (FileInputStream stream = new FileInputStream(target);){
                json = JsonParser.parseReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8)).getAsJsonObject();
            }
            catch (IOException e) {
                this.error("Failed to read " + target);
                e.printStackTrace();
                return false;
            }
            JsonObject _profiles = json.getAsJsonObject("profiles");
            if (_profiles == null) {
                _profiles = new JsonObject();
                json.add("profiles", _profiles);
            }
            if ((_profile = _profiles.getAsJsonObject(this.profile.getProfile())) == null) {
                _profile = new JsonObject();
                _profile.addProperty("name", this.profile.getProfile());
                _profile.addProperty("type", "custom");
                _profiles.add(this.profile.getProfile(), _profile);
            }
            _profile.addProperty("lastVersionId", this.profile.getVersion());
            String icon = this.profile.getIcon();
            if (icon != null) {
                _profile.addProperty("icon", icon);
            }
            String jstring = Util.GSON.toJson(json);
            Files.write(target.toPath(), jstring.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            this.error("There was a problem writing the launch profile,  is it write protected?");
            return false;
        }
        return true;
    }

    @Override
    public boolean isPathValid(File targetDir) {
        return targetDir.exists() && (new File(targetDir, "launcher_profiles.json").exists() || new File(targetDir, "launcher_profiles_microsoft_store.json").exists());
    }

    @Override
    public String getFileError(File targetDir) {
        if (targetDir.exists()) {
            return "The directory is missing a launcher profile. Please run the minecraft launcher first";
        }
        return "There is no minecraft directory set up. Either choose an alternative, or run the minecraft launcher to create one";
    }

    @Override
    public String getSuccessMessage() {
        if (this.downloadedCount() > 0) {
            return String.format("Successfully installed client profile %s for version %s into launcher, and downloaded %d libraries", this.profile.getProfile(), this.profile.getVersion(), this.downloadedCount());
        }
        return String.format("Successfully installed client profile %s for version %s into launcher", this.profile.getProfile(), this.profile.getVersion());
    }
}

