/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installer;

import argo.format.PrettyJsonFormatter;
import argo.jdom.JdomParser;
import argo.jdom.JsonField;
import argo.jdom.JsonNode;
import argo.jdom.JsonNodeFactories;
import argo.jdom.JsonRootNode;
import argo.jdom.JsonStringNode;
import argo.saj.InvalidSyntaxException;
import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import net.minecraftforge.installer.ActionType;
import net.minecraftforge.installer.Artifact;
import net.minecraftforge.installer.DownloadUtils;
import net.minecraftforge.installer.IMonitor;
import net.minecraftforge.installer.LibraryInfo;
import net.minecraftforge.installer.MirrorData;
import net.minecraftforge.installer.Mod;
import net.minecraftforge.installer.OptionalLibrary;
import net.minecraftforge.installer.VersionInfo;

public class ClientInstall
implements ActionType {
    private List<Artifact> grabbed;

    @Override
    public boolean run(File target, Predicate<String> optionals) {
        JsonRootNode jsonProfileData;
        if (!target.exists()) {
            JOptionPane.showMessageDialog(null, "There is no minecraft installation at this location!", "Error", 0);
            return false;
        }
        File launcherProfiles = new File(target, "launcher_profiles.json");
        if (!launcherProfiles.exists()) {
            JOptionPane.showMessageDialog(null, "There is no minecraft launcher profile at this location, you need to run the launcher first!", "Error", 0);
            return false;
        }
        File versionRootDir = new File(target, "versions");
        File versionTarget = new File(versionRootDir, VersionInfo.getVersionTarget());
        if (!versionTarget.mkdirs() && !versionTarget.isDirectory()) {
            if (!versionTarget.delete()) {
                JOptionPane.showMessageDialog(null, "There was a problem with the launcher version data. You will need to clear " + versionTarget.getAbsolutePath() + " manually", "Error", 0);
            } else {
                versionTarget.mkdirs();
            }
        }
        File librariesDir = new File(target, "libraries");
        IMonitor monitor = DownloadUtils.buildMonitor();
        List<LibraryInfo> libraries = VersionInfo.getLibraries("clientreq", optionals);
        monitor.setMaximum(libraries.size() + 3);
        int progress = 3;
        File versionJsonFile = new File(versionTarget, VersionInfo.getVersionTarget() + ".json");
        if (!VersionInfo.isInheritedJson()) {
            File clientJarFile = new File(versionTarget, VersionInfo.getVersionTarget() + ".jar");
            File minecraftJarFile = VersionInfo.getMinecraftFile(versionRootDir);
            try {
                boolean delete = false;
                monitor.setNote("Considering minecraft client jar");
                monitor.setProgress(1);
                if (!minecraftJarFile.exists()) {
                    minecraftJarFile = File.createTempFile("minecraft_client", ".jar");
                    delete = true;
                    monitor.setNote(String.format("Downloading minecraft client version %s", VersionInfo.getMinecraftVersion()));
                    String clientUrl = String.format("https://s3.amazonaws.com/Minecraft.Download/versions/{MCVER}/{MCVER}.jar".replace("{MCVER}", VersionInfo.getMinecraftVersion()), new Object[0]);
                    System.out.println("  Temp File: " + minecraftJarFile.getAbsolutePath());
                    if (!DownloadUtils.downloadFileEtag("minecraft server", minecraftJarFile, clientUrl)) {
                        minecraftJarFile.delete();
                        JOptionPane.showMessageDialog(null, "Downloading minecraft failed, invalid e-tag checksum.\nTry again, or use the official launcher to run Minecraft " + VersionInfo.getMinecraftVersion() + " first.", "Error downloading", 0);
                        return false;
                    }
                    monitor.setProgress(2);
                }
                if (VersionInfo.getStripMetaInf()) {
                    monitor.setNote("Copying and filtering minecraft client jar");
                    this.copyAndStrip(minecraftJarFile, clientJarFile);
                    monitor.setProgress(3);
                } else {
                    monitor.setNote("Copying minecraft client jar");
                    Files.copy(minecraftJarFile, clientJarFile);
                    monitor.setProgress(3);
                }
                if (delete) {
                    minecraftJarFile.delete();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(null, "You need to run the version " + VersionInfo.getMinecraftVersion() + " manually at least once", "Error", 0);
                return false;
            }
        }
        File targetLibraryFile = VersionInfo.getLibraryPath(librariesDir);
        this.grabbed = Lists.newArrayList();
        ArrayList<Artifact> bad = Lists.newArrayList();
        progress = DownloadUtils.downloadInstalledLibraries(true, librariesDir, monitor, libraries, progress, this.grabbed, bad);
        monitor.close();
        if (bad.size() > 0) {
            String list = Joiner.on("\n").join(bad);
            JOptionPane.showMessageDialog(null, "These libraries failed to download. Try again.\n" + list, "Error downloading", 0);
            return false;
        }
        if (!targetLibraryFile.getParentFile().mkdirs() && !targetLibraryFile.getParentFile().isDirectory()) {
            if (!targetLibraryFile.getParentFile().delete()) {
                JOptionPane.showMessageDialog(null, "There was a problem with the launcher version data. You will need to clear " + targetLibraryFile.getAbsolutePath() + " manually", "Error", 0);
                return false;
            }
            targetLibraryFile.getParentFile().mkdirs();
        }
        String modListType = VersionInfo.getModListType();
        File modListFile = new File(target, "mods/mod_list.json");
        JsonRootNode versionJson = JsonNodeFactories.object(VersionInfo.getVersionInfo().getFields());
        if ("absolute".equals(modListType)) {
            modListFile = new File(versionTarget, "mod_list.json");
            JsonStringNode node = (JsonStringNode)versionJson.getNode("minecraftArguments");
            try {
                Field value = JsonStringNode.class.getDeclaredField("value");
                value.setAccessible(true);
                String args = (String)value.get(node);
                value.set(node, args + " --modListFile \"absolute:" + modListFile.getAbsolutePath() + "\"");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!"none".equals(modListType) && !OptionalLibrary.saveModListJson(librariesDir, modListFile, VersionInfo.getOptionals(), optionals)) {
            JOptionPane.showMessageDialog(null, "Failed to write mod_list.json, optional mods may not be loaded.", "Error", 0);
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(versionJson, writer);
            ((Writer)writer).close();
            byte[] output = bos.toByteArray();
            ArrayList<OptionalLibrary> lst = Lists.newArrayList();
            for (OptionalLibrary opt : VersionInfo.getOptionals()) {
                if (!optionals.apply(opt.getArtifact()) || !opt.isInjected()) continue;
                lst.add(opt);
            }
            if (lst.size() > 0) {
                BufferedReader reader = new BufferedReader(new StringReader(new String(output, Charsets.UTF_8)));
                bos = new ByteArrayOutputStream();
                PrintWriter printer = new PrintWriter(new OutputStreamWriter((OutputStream)bos, Charsets.UTF_8));
                String line = null;
                String prefix = null;
                boolean added = false;
                while ((line = reader.readLine()) != null) {
                    if (added) {
                        printer.println(line);
                        continue;
                    }
                    if (line.contains("\"libraries\": [")) {
                        prefix = line.substring(0, line.indexOf(34));
                    } else if (prefix != null && line.startsWith(prefix + "]")) {
                        printer.println(prefix + "\t,");
                        for (int x = 0; x < lst.size(); ++x) {
                            OptionalLibrary opt = (OptionalLibrary)lst.get(x);
                            printer.println(prefix + "\t{");
                            printer.println(prefix + "\t\t\"name\": \"" + opt.getArtifact() + "\",");
                            printer.println(prefix + "\t\t\"url\": \"" + opt.getMaven() + "\"");
                            if (x < lst.size() - 1) {
                                printer.println(prefix + "\t},");
                                continue;
                            }
                            printer.println(prefix + "\t}");
                        }
                        added = true;
                    }
                    printer.println(line);
                }
                printer.close();
                output = bos.toByteArray();
            }
            Files.write(output, versionJsonFile);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the launcher version data,  is it write protected?", "Error", 0);
            return false;
        }
        try {
            VersionInfo.extractFile(targetLibraryFile);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the system library file", "Error", 0);
            return false;
        }
        JdomParser parser = new JdomParser();
        try {
            jsonProfileData = parser.parse(Files.newReader(launcherProfiles, Charsets.UTF_8));
        }
        catch (InvalidSyntaxException e) {
            JOptionPane.showMessageDialog(null, "The launcher profile file is corrupted. Re-run the minecraft launcher to fix it!", "Error", 0);
            return false;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
        HashMap<JsonStringNode, JsonNode> profileCopy = Maps.newHashMap(jsonProfileData.getNode("profiles").getFields());
        HashMap<JsonStringNode, JsonNode> rootCopy = Maps.newHashMap(jsonProfileData.getFields());
        if (profileCopy.containsKey(JsonNodeFactories.string(VersionInfo.getProfileName()))) {
            HashMap<JsonStringNode, JsonNode> forgeProfileCopy = Maps.newHashMap(profileCopy.get(JsonNodeFactories.string(VersionInfo.getProfileName())).getFields());
            forgeProfileCopy.put(JsonNodeFactories.string("name"), JsonNodeFactories.string(VersionInfo.getProfileName()));
            forgeProfileCopy.put(JsonNodeFactories.string("lastVersionId"), JsonNodeFactories.string(VersionInfo.getVersionTarget()));
        } else {
            JsonField[] fields = new JsonField[]{JsonNodeFactories.field("name", (JsonNode)JsonNodeFactories.string(VersionInfo.getProfileName())), JsonNodeFactories.field("lastVersionId", (JsonNode)JsonNodeFactories.string(VersionInfo.getVersionTarget()))};
            profileCopy.put(JsonNodeFactories.string(VersionInfo.getProfileName()), JsonNodeFactories.object(fields));
        }
        JsonRootNode profileJsonCopy = JsonNodeFactories.object(profileCopy);
        rootCopy.put(JsonNodeFactories.string("profiles"), profileJsonCopy);
        jsonProfileData = JsonNodeFactories.object(rootCopy);
        try {
            BufferedWriter newWriter = Files.newWriter(launcherProfiles, Charsets.UTF_8);
            PrettyJsonFormatter.fieldOrderPreservingPrettyJsonFormatter().format(jsonProfileData, newWriter);
            newWriter.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "There was a problem writing the launch profile,  is it write protected?", "Error", 0);
            return false;
        }
        List<Mod> mods = VersionInfo.getMods();
        if (mods.size() > 0) {
            File modsDir = new File(target, "mods");
            if (!modsDir.isDirectory()) {
                modsDir.mkdir();
            }
            for (Mod mod : mods) {
                File modFile = new File(modsDir, mod.name + ".jar");
                InputStream inStream = null;
                if (mod.path.startsWith("http://")) {
                    try {
                        URL url = new URL(mod.path);
                        URLConnection con = url.openConnection();
                        con.setConnectTimeout(5000);
                        con.setReadTimeout(5000);
                        con.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:70.0) Gecko/20100101 Firefox/70.0");
                        inStream = con.getInputStream();
                    }
                    catch (MalformedURLException e) {
                        JOptionPane.showMessageDialog(null, "Invalid URL format in installer configuration for mod: " + mod.name + ", url: " + mod.path, "Error", 0);
                        return false;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Unable to download mod: " + mod.name + ", url: " + mod.path, "Error", 0);
                        return false;
                    }
                } else {
                    inStream = ClientInstall.class.getResourceAsStream(mod.path);
                    if (inStream == null) {
                        JOptionPane.showMessageDialog(null, "Mod missing in installer jar: " + mod.name + ", path: " + mod.path, "Error", 0);
                        return false;
                    }
                }
                try {
                    FileOutputStream outStream = new FileOutputStream(modFile);
                    ByteStreams.copy(inStream, outStream);
                    inStream.close();
                    outStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(null, "There was an error while installing mod: " + mod.name, "Error", 0);
                    return false;
                }
            }
        }
        return true;
    }

    private void copyAndStrip(File sourceJar, File targetJar) throws IOException {
        ZipFile in = new ZipFile(sourceJar);
        ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(targetJar)));
        for (ZipEntry zipEntry : Collections.list(in.entries())) {
            if (zipEntry.isDirectory()) {
                out.putNextEntry(zipEntry);
                continue;
            }
            if (zipEntry.getName().startsWith("META-INF")) continue;
            ZipEntry n = new ZipEntry(zipEntry.getName());
            n.setTime(zipEntry.getTime());
            out.putNextEntry(n);
            out.write(ClientInstall.readEntry(in, zipEntry));
        }
        in.close();
        out.close();
    }

    private static byte[] readEntry(ZipFile inFile, ZipEntry entry) throws IOException {
        return ClientInstall.readFully(inFile.getInputStream(entry));
    }

    private static byte[] readFully(InputStream stream) throws IOException {
        int len;
        byte[] data = new byte[4096];
        ByteArrayOutputStream entryBuffer = new ByteArrayOutputStream();
        do {
            if ((len = stream.read(data)) <= 0) continue;
            entryBuffer.write(data, 0, len);
        } while (len != -1);
        return entryBuffer.toByteArray();
    }

    @Override
    public boolean isPathValid(File targetDir) {
        if (targetDir.exists()) {
            File launcherProfiles = new File(targetDir, "launcher_profiles.json");
            return launcherProfiles.exists();
        }
        return false;
    }

    @Override
    public String getFileError(File targetDir) {
        if (targetDir.exists()) {
            return "The directory is missing a launcher profile. Please run the minecraft launcher first";
        }
        return "There is no minecraft directory set up. Either choose an alternative, or run the minecraft launcher to create one";
    }

    @Override
    public String getSuccessMessage() {
        if (this.grabbed.size() > 0) {
            return String.format("Successfully installed client profile %s for version %s into launcher and grabbed %d required libraries", VersionInfo.getProfileName(), VersionInfo.getVersion(), this.grabbed.size());
        }
        return String.format("Successfully installed client profile %s for version %s into launcher", VersionInfo.getProfileName(), VersionInfo.getVersion());
    }

    @Override
    public String getSponsorMessage() {
        return MirrorData.INSTANCE.hasMirrors() ? String.format("<html><a href='%s'>Data kindly mirrored by %s</a></html>", MirrorData.INSTANCE.getSponsorURL(), MirrorData.INSTANCE.getSponsorName()) : null;
    }
}

