/*
 * Decompiled with CFR 0.152.
 */
package sckioskmode.gui.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TimeoutWarningScreen
extends Screen {
    private final Screen previousGuiScreen;
    private Timer timer = new Timer(true);
    private final String logoutBtnText = "Logout / New player";
    private Button logoutBtn;

    public TimeoutWarningScreen(Screen previousGuiScreen, int timeout) {
        super((ITextComponent)new StringTextComponent(""));
        this.previousGuiScreen = previousGuiScreen;
        final long timeoutTime = System.currentTimeMillis() + (long)timeout;
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Minecraft.func_71410_x().func_213167_f(() -> {
                    if (TimeoutWarningScreen.this.timer == null) {
                        return;
                    }
                    long currentTime = System.currentTimeMillis();
                    if (currentTime >= timeoutTime) {
                        TimeoutWarningScreen.this.handleTimeout();
                        return;
                    }
                    TimeoutWarningScreen.this.logoutBtn.func_238482_a_((ITextComponent)new StringTextComponent("Logout / New player" + String.format(" (%d)", (timeoutTime - currentTime) / 1000L)));
                });
            }
        }, 0L, 1000L);
    }

    public void func_231160_c_() {
        int btnWidth = 150;
        int btnHeight = 20;
        int btnSpacing = 10;
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - btnWidth - btnSpacing / 2, this.field_230709_l_ / 2, btnWidth, btnHeight, (ITextComponent)new StringTextComponent("Continue"), button -> {
            this.cancelTimer();
            Minecraft.func_71410_x().func_147108_a(this.previousGuiScreen);
        }));
        this.logoutBtn = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + btnSpacing / 2, this.field_230709_l_ / 2, btnWidth, btnHeight, (ITextComponent)new StringTextComponent(this.logoutBtnText), button -> this.handleTimeout()));
    }

    private void handleTimeout() {
        this.timer.cancel();
        this.timer = null;
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        if (player != null) {
            player.func_71165_d("/logout");
        }
        this.field_230706_i_.func_147108_a(this.previousGuiScreen);
    }

    private void cancelTimer() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        int offset = this.field_230709_l_ / 2 - 25;
        TimeoutWarningScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"You are about to be logged out due to inactivity.", (int)(this.field_230708_k_ / 2), (int)offset, (int)0xFFFFFF);
        TimeoutWarningScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Click to continue playing.", (int)(this.field_230708_k_ / 2), (int)(offset += 10), (int)0xFFFFFF);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }
}

