/*
 * Decompiled with CFR 0.152.
 */
package sckioskmode.osutils;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinUser;

public final class LowLevelKioskModeKeyBlocker {
    private static WinUser.HHOOK hhook;
    private static Thread messageTranslationThread;
    private static final int WH_KEYBOARD_LL = 13;

    private LowLevelKioskModeKeyBlocker() {
    }

    public static void enable() {
        if (hhook != null) {
            return;
        }
        final WinUser.LowLevelKeyboardProc keyboardHook = new WinUser.LowLevelKeyboardProc(){

            @Override
            public WinDef.LRESULT callback(int nCode, WinDef.WPARAM wParam, WinUser.KBDLLHOOKSTRUCT lParam) {
                if (LowLevelKioskModeKeyBlocker.shouldBlockKeyEvent(wParam, lParam)) {
                    return new WinDef.LRESULT(1L);
                }
                return User32.INSTANCE.CallNextHookEx(null, nCode, wParam, new WinDef.LPARAM(lParam.getPointer().getLong(0L)));
            }
        };
        messageTranslationThread = new Thread(){

            @Override
            public void run() {
                int result;
                WinDef.HMODULE hMod = Kernel32.INSTANCE.GetModuleHandle(null);
                hhook = User32.INSTANCE.SetWindowsHookEx(13, keyboardHook, hMod, 0);
                if (hhook == null) {
                    System.out.println("[ERROR] Registering low-level keyboard hook failed.");
                    return;
                }
                WinUser.MSG msg = new WinUser.MSG();
                while ((result = User32.INSTANCE.GetMessage(msg, null, 0, 0)) != 0 && result != -1 && !this.isInterrupted()) {
                    User32.INSTANCE.TranslateMessage(msg);
                    User32.INSTANCE.DispatchMessage(msg);
                }
            }
        };
        messageTranslationThread.setDaemon(true);
        messageTranslationThread.start();
    }

    public static void disable() {
        if (LowLevelKioskModeKeyBlocker.isEnabled()) {
            messageTranslationThread.interrupt();
            messageTranslationThread = null;
            User32.INSTANCE.UnhookWindowsHookEx(hhook);
            hhook = null;
        }
    }

    public static boolean isEnabled() {
        return messageTranslationThread != null;
    }

    private static boolean shouldBlockKeyEvent(WinDef.WPARAM keyEventType, WinUser.KBDLLHOOKSTRUCT info) {
        if (info.vkCode >= 21 && info.vkCode <= 26 || info.vkCode >= 28 && info.vkCode <= 31) {
            return true;
        }
        if (info.vkCode >= 112 && info.vkCode <= 135) {
            return true;
        }
        if (info.vkCode >= 166 && info.vkCode <= 183) {
            return true;
        }
        switch (info.vkCode) {
            case 42: 
            case 43: 
            case 47: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 164: 
            case 165: 
            case 250: 
            case 251: 
            case 255: {
                return true;
            }
        }
        return false;
    }

    static {
        messageTranslationThread = null;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (LowLevelKioskModeKeyBlocker.isEnabled()) {
                    LowLevelKioskModeKeyBlocker.disable();
                }
            }
        });
    }
}

