/*
 * Decompiled with CFR 0.152.
 */
package io.github.pieter12345.mojangauthentication;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.github.pieter12345.mojangauthentication.AuthInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class MojangAuthentication {
    public static AuthInfo authenticateWithMojang(String username, String password) {
        if (username.isEmpty() || password.isEmpty()) {
            return null;
        }
        MojangAuthentication.debug("Sending authentication request to Mojang for username: " + username);
        String jsonStr = "{\"agent\": {\"name\": \"Minecraft\", \"version\": 1}, \"username\":\"" + username + "\", \"password\":\"" + password + "\"}";
        String res = MojangAuthentication.httpRequest("https://authserver.mojang.com/authenticate", jsonStr);
        if (res == null || res.isEmpty()) {
            return null;
        }
        MojangAuthentication.debug("Mojang authentication response: " + res);
        LinkedHashMap<String, Object> jsonObject = MojangAuthentication.decodeJson(res);
        if (jsonObject == null) {
            MojangAuthentication.debug("Mojang authentication was NOT succesful - Failed to decode json response: " + res);
            return null;
        }
        for (String key : new String[]{"accessToken", "clientToken", "selectedProfile"}) {
            if (jsonObject.containsKey(key)) continue;
            MojangAuthentication.debug("Mojang authentication was NOT succesful (" + key + " not found in response).");
            return null;
        }
        Object selectedProfileObject = jsonObject.get("selectedProfile");
        if (!(selectedProfileObject instanceof LinkedHashMap)) {
            MojangAuthentication.debug("Mojang session refresh was NOT succesful (expected selectedProfile to be an object in the response).");
            return null;
        }
        LinkedHashMap selectedProfileMap = (LinkedHashMap)selectedProfileObject;
        for (String key : new String[]{"id", "name"}) {
            if (selectedProfileMap.containsKey(key)) continue;
            MojangAuthentication.debug("Mojang session refresh was NOT succesful (" + key + " not found in \"selectedProfile\" in response).");
            return null;
        }
        AuthInfo authInfo = new AuthInfo((String)selectedProfileMap.get("name"), (String)selectedProfileMap.get("id"), (String)jsonObject.get("accessToken"), (String)jsonObject.get("clientToken"), selectedProfileMap.containsKey("legacy") && (Boolean)selectedProfileMap.get("legacy") != false);
        MojangAuthentication.debug("Mojang authentication was succesful.");
        MojangAuthentication.debug("\tusername = " + authInfo.username);
        MojangAuthentication.debug("\tuuid = " + authInfo.uuid);
        MojangAuthentication.debug("\taccessToken = " + authInfo.accessToken);
        MojangAuthentication.debug("\tlegacy = " + authInfo.legacy);
        return authInfo;
    }

    public static AuthInfo authenticateWithMojang(String username) {
        JLabel textLabel = new JLabel("Please enter your username and password:");
        JTextField usernameField = new JTextField(username);
        JPasswordField passField = new JPasswordField(20);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)textLabel, "North");
        panel.add((Component)usernameField, "Center");
        panel.add((Component)passField, "South");
        int choice = JOptionPane.showOptionDialog(null, panel, "Session Refression", 1, -1, null, new String[]{"Ok", "Cancel"}, "Ok");
        if (choice == 0 && !usernameField.getText().isEmpty() && passField.getPassword().length != 0) {
            return MojangAuthentication.authenticateWithMojang(usernameField.getText(), new String(passField.getPassword()));
        }
        JOptionPane.showMessageDialog(null, "Invalid credentials.", "Error", 0);
        return null;
    }

    public static AuthInfo authenticateWithMojang() {
        return MojangAuthentication.authenticateWithMojang("");
    }

    public static AuthInfo refreshSession(String clientToken, String accessToken) {
        if (clientToken.isEmpty() || accessToken.isEmpty()) {
            return null;
        }
        MojangAuthentication.debug("Sending session refresh request to Mojang.");
        String jsonStr = "{\"accessToken\": \"" + accessToken + "\", \"clientToken\": \"" + clientToken + "\"}";
        String res = MojangAuthentication.httpRequest("https://authserver.mojang.com/refresh", jsonStr);
        MojangAuthentication.debug("Mojang session refresh response: " + res);
        if (res == null || res.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> jsonObject = MojangAuthentication.decodeJson(res);
        if (jsonObject == null) {
            MojangAuthentication.debug("Mojang session refresh was NOT succesful - Failed to decode json response: " + res);
            return null;
        }
        for (String key : new String[]{"accessToken", "clientToken", "selectedProfile"}) {
            if (jsonObject.containsKey(key)) continue;
            MojangAuthentication.debug("Mojang session refresh was NOT succesful (" + key + " not found in response).");
            return null;
        }
        Object selectedProfileObject = jsonObject.get("selectedProfile");
        if (!(selectedProfileObject instanceof LinkedHashMap)) {
            MojangAuthentication.debug("Mojang session refresh was NOT succesful (expected selectedProfile to be an object in the response).");
            return null;
        }
        LinkedHashMap selectedProfileMap = (LinkedHashMap)selectedProfileObject;
        for (String key : new String[]{"id", "name"}) {
            if (selectedProfileMap.containsKey(key)) continue;
            MojangAuthentication.debug("Mojang session refresh was NOT succesful (" + key + " not found in \"selectedProfile\" in response).");
            return null;
        }
        AuthInfo authInfo = new AuthInfo((String)selectedProfileMap.get("name"), (String)selectedProfileMap.get("id"), (String)jsonObject.get("accessToken"), (String)jsonObject.get("clientToken"), null);
        MojangAuthentication.debug("Mojang session refresh was succesful.");
        MojangAuthentication.debug("\tusername = " + authInfo.username);
        MojangAuthentication.debug("\tuuid = " + authInfo.uuid);
        MojangAuthentication.debug("\taccessToken = " + authInfo.accessToken);
        MojangAuthentication.debug("\tlegacy = " + authInfo.legacy);
        return authInfo;
    }

    public static boolean validateSession(String clientToken, String accessToken) {
        if (clientToken.isEmpty() || accessToken.isEmpty()) {
            return false;
        }
        MojangAuthentication.debug("Sending session validation request to Mojang.");
        String jsonStr = "{\"accessToken\": \"" + accessToken + "\", \"clientToken\": \"" + clientToken + "\"}";
        String res = MojangAuthentication.httpRequest("https://authserver.mojang.com/validate", jsonStr);
        if (res == null) {
            return false;
        }
        if (res.isEmpty()) {
            MojangAuthentication.debug("Session valid.");
            return true;
        }
        MojangAuthentication.debug("Session not valid.");
        return false;
    }

    public static boolean invalidateSession(String clientToken, String accessToken) {
        if (clientToken.isEmpty() || accessToken.isEmpty()) {
            return false;
        }
        MojangAuthentication.debug("Sending session invalidation request to Mojang.");
        String jsonStr = "{\"accessToken\": \"" + accessToken + "\", \"clientToken\": \"" + clientToken + "\"}";
        String res = MojangAuthentication.httpRequest("https://authserver.mojang.com/invalidate", jsonStr);
        if (res.isEmpty()) {
            MojangAuthentication.debug("Session invalidated.");
            return true;
        }
        MojangAuthentication.debug("Session not invalidated (likely, it's not valid anymore).");
        return false;
    }

    public static boolean invalidateAllSessions(String username, String password) {
        if (username.isEmpty() || password.isEmpty()) {
            return false;
        }
        MojangAuthentication.debug("Sending signout request to Mojang.");
        String jsonStr = "{\"username\": \"" + username + "\", \"password\": \"" + password + "\"}";
        String res = MojangAuthentication.httpRequest("https://authserver.mojang.com/signout", jsonStr);
        if (res.isEmpty()) {
            MojangAuthentication.debug("Signed out.");
            return true;
        }
        MojangAuthentication.debug("Failed to sign out.");
        return false;
    }

    public static String httpRequest(String url, byte[] payload) {
        try {
            BufferedReader inStream;
            URLConnection con = new URL(url).openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setRequestProperty("Accept-Charset", "UTF-8");
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Content-Length", Integer.toString(payload.length));
            OutputStream requestStream = con.getOutputStream();
            requestStream.write(payload, 0, payload.length);
            requestStream.close();
            int responseCode = ((HttpURLConnection)con).getResponseCode();
            if (responseCode == 200) {
                inStream = new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8"));
            } else {
                if (responseCode == 204) {
                    return "";
                }
                inStream = new BufferedReader(new InputStreamReader(((HttpURLConnection)con).getErrorStream(), "UTF-8"));
            }
            String res = inStream.readLine();
            inStream.close();
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String httpRequest(String url, String payload) {
        return MojangAuthentication.httpRequest(url, payload.getBytes());
    }

    private static LinkedHashMap<String, Object> decodeJson(String jsonString) {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(jsonString));
        return MojangAuthentication.decodeJson(jsonReader);
    }

    private static LinkedHashMap<String, Object> decodeJson(JsonReader jsonReader) {
        try {
            LinkedHashMap<String, Object> jsonObject = MojangAuthentication.getJsonObject(jsonReader);
            jsonReader.close();
            return jsonObject;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ArrayList<Object> getJsonArray(JsonReader jsonReader) throws IOException, Exception {
        ArrayList<Object> ret = new ArrayList<Object>();
        jsonReader.beginArray();
        block12: while (jsonReader.hasNext()) {
            switch (jsonReader.peek()) {
                case BEGIN_ARRAY: {
                    ret.add(MojangAuthentication.getJsonArray(jsonReader));
                    continue block12;
                }
                case BEGIN_OBJECT: {
                    ret.add(MojangAuthentication.getJsonObject(jsonReader));
                    continue block12;
                }
                case BOOLEAN: {
                    ret.add(jsonReader.nextBoolean());
                    continue block12;
                }
                case END_ARRAY: {
                    throw new Exception("END_ARRAY found in a JSON array while hasNext() returned true.");
                }
                case END_DOCUMENT: {
                    throw new Exception("END_DOCUMENT found in a JSON array.");
                }
                case END_OBJECT: {
                    throw new Exception("END_OBJECT found in a JSON array without BEGIN_OBJECT.");
                }
                case NAME: {
                    throw new Exception("NAME found in a JSON array.");
                }
                case NULL: {
                    jsonReader.nextNull();
                    ret.add(null);
                    continue block12;
                }
                case NUMBER: {
                    ret.add(jsonReader.nextLong());
                    continue block12;
                }
                case STRING: {
                    ret.add(jsonReader.nextString());
                    continue block12;
                }
            }
            throw new Exception("Unknown JsonToken found in a JSON array.");
        }
        jsonReader.endArray();
        return ret;
    }

    private static LinkedHashMap<String, Object> getJsonObject(JsonReader jsonReader) throws IOException, Exception {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        jsonReader.beginObject();
        block12: while (jsonReader.hasNext()) {
            if (!jsonReader.peek().equals((Object)JsonToken.NAME)) {
                throw new Exception("Missing NAME in a JSON object.");
            }
            String name = jsonReader.nextName();
            if (!jsonReader.hasNext()) {
                throw new Exception("Missing value in a JSON object for NAME: " + name + ".");
            }
            switch (jsonReader.peek()) {
                case BEGIN_ARRAY: {
                    ret.put(name, MojangAuthentication.getJsonArray(jsonReader));
                    continue block12;
                }
                case BEGIN_OBJECT: {
                    ret.put(name, MojangAuthentication.getJsonObject(jsonReader));
                    continue block12;
                }
                case BOOLEAN: {
                    ret.put(name, jsonReader.nextBoolean());
                    continue block12;
                }
                case END_ARRAY: {
                    throw new Exception("END_ARRAY found inside of a JSON object without BEGIN_ARRAY.");
                }
                case END_DOCUMENT: {
                    throw new Exception("END_DOCUMENT found in a JSON object.");
                }
                case END_OBJECT: {
                    throw new Exception("END_OBJECT found inside of a JSON object while hasNext() returned true.");
                }
                case NAME: {
                    throw new Exception("NAME found as value in a JSON object for NAME: " + name + ".");
                }
                case NULL: {
                    jsonReader.nextNull();
                    ret.put(name, null);
                    continue block12;
                }
                case NUMBER: {
                    ret.put(name, jsonReader.nextLong());
                    continue block12;
                }
                case STRING: {
                    ret.put(name, jsonReader.nextString());
                    continue block12;
                }
            }
            throw new Exception("Unknown JsonToken found in a JSON object.");
        }
        jsonReader.endObject();
        return ret;
    }

    public static AuthInfo getSessionUsingProfilesFile(String uuid, boolean promptForCredentialsOnFail) {
        block14: {
            String fileName = "launcher_profiles.json";
            File profileFile = new File(fileName);
            if (uuid != null && profileFile.exists()) {
                JsonReader reader;
                try {
                    reader = new JsonReader((Reader)new FileReader(profileFile));
                }
                catch (FileNotFoundException e) {
                    MojangAuthentication.debug("File should exist but doesn't at " + profileFile.getAbsolutePath());
                    e.printStackTrace();
                    break block14;
                }
                LinkedHashMap<String, Object> jsonObject = MojangAuthentication.decodeJson(reader);
                if (jsonObject == null) {
                    MojangAuthentication.debug("Failed to decode json in file: " + profileFile.getAbsolutePath());
                } else {
                    LinkedHashMap authenticationDatabaseMap;
                    String username = null;
                    String accessToken = null;
                    String clientToken = null;
                    Boolean legacy = null;
                    Object var = jsonObject.get("clientToken");
                    if (var != null && var instanceof String) {
                        clientToken = ((String)var).replaceAll("\\-", "");
                    }
                    if ((var = jsonObject.get("authenticationDatabase")) != null && var instanceof LinkedHashMap && (var = (authenticationDatabaseMap = (LinkedHashMap)var).get(uuid)) != null && var instanceof LinkedHashMap) {
                        LinkedHashMap profile = (LinkedHashMap)var;
                        if ((var = profile.get("displayName")) != null && var instanceof String) {
                            username = (String)var;
                        }
                        if ((var = profile.get("accessToken")) != null && var instanceof String) {
                            accessToken = (String)var;
                        }
                        if ((var = profile.get("legacy")) != null && var instanceof Boolean) {
                            legacy = (Boolean)var;
                        }
                    }
                    if (clientToken != null && accessToken != null) {
                        if (MojangAuthentication.validateSession(clientToken, accessToken) && username != null) {
                            return new AuthInfo(username, uuid, accessToken, clientToken, legacy);
                        }
                        AuthInfo refreshAuthInfo = MojangAuthentication.refreshSession(clientToken, accessToken);
                        if (refreshAuthInfo != null) {
                            MojangAuthentication.storeSessionInfo(refreshAuthInfo);
                            return refreshAuthInfo;
                        }
                    }
                    if (promptForCredentialsOnFail) {
                        AuthInfo authInfo = MojangAuthentication.authenticateWithMojang(username == null ? "" : username);
                        MojangAuthentication.storeSessionInfo(authInfo);
                        return authInfo;
                    }
                    return null;
                }
            }
        }
        AuthInfo authInfo = MojangAuthentication.authenticateWithMojang();
        MojangAuthentication.storeSessionInfo(authInfo);
        return authInfo;
    }

    private static boolean storeSessionInfo(AuthInfo authInfo) {
        if (authInfo == null) {
            return false;
        }
        String fileName = "launcher_profiles.json";
        File profileFile = new File(fileName);
        try {
            LinkedHashMap profile;
            LinkedHashMap authenticationDatabase;
            if (!profileFile.exists() && !profileFile.createNewFile()) {
                MojangAuthentication.debug("Unable to create file: " + profileFile.getAbsolutePath());
                return false;
            }
            JsonReader reader = new JsonReader((Reader)new FileReader(profileFile));
            LinkedHashMap<String, Object> jsonObject = MojangAuthentication.decodeJson(reader);
            if (jsonObject == null) {
                MojangAuthentication.debug("Failed to decode json in file: " + profileFile.getAbsolutePath());
                return false;
            }
            String dashedClientToken = authInfo.clientToken;
            if (!dashedClientToken.contains("-") && dashedClientToken.length() == 32) {
                dashedClientToken = dashedClientToken.substring(0, 8) + "-" + dashedClientToken.substring(8, 12) + "-" + dashedClientToken.substring(12, 16) + "-" + dashedClientToken.substring(16, 20) + "-" + dashedClientToken.substring(20, 32);
            }
            jsonObject.put("clientToken", dashedClientToken);
            Object authenticationDatabaseRaw = jsonObject.get("authenticationDatabase");
            if (authenticationDatabaseRaw != null && authenticationDatabaseRaw instanceof LinkedHashMap) {
                authenticationDatabase = (LinkedHashMap)authenticationDatabaseRaw;
            } else {
                authenticationDatabase = new LinkedHashMap();
                jsonObject.put("authenticationDatabase", authenticationDatabase);
            }
            Object profileRaw = authenticationDatabase.get(authInfo.uuid);
            if (profileRaw != null && profileRaw instanceof LinkedHashMap) {
                profile = (LinkedHashMap)profileRaw;
            } else {
                profile = new LinkedHashMap();
                authenticationDatabase.put(authInfo.uuid, profile);
            }
            if (authInfo.username != null && !authInfo.username.isEmpty()) {
                profile.put("displayName", authInfo.username);
            }
            if (authInfo.accessToken != null && !authInfo.accessToken.isEmpty()) {
                profile.put("accessToken", authInfo.accessToken);
            }
            if (authInfo.uuid != null && !authInfo.uuid.isEmpty()) {
                String dashedUuid = authInfo.uuid;
                if (!dashedUuid.contains("-") && dashedUuid.length() == 32) {
                    dashedUuid = dashedUuid.substring(0, 8) + "-" + dashedUuid.substring(8, 12) + "-" + dashedUuid.substring(12, 16) + "-" + dashedUuid.substring(16, 20) + "-" + dashedUuid.substring(20, 32);
                }
                profile.put("uuid", dashedUuid);
            }
            if (authInfo.username != null && !authInfo.username.isEmpty() && authInfo.legacy != null && authInfo.legacy.booleanValue()) {
                profile.put("username", authInfo.username);
            }
            JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(profileFile));
            jsonWriter.setIndent("  ");
            MojangAuthentication.encodeJson(jsonObject, jsonWriter);
            jsonWriter.flush();
            jsonWriter.close();
            return true;
        }
        catch (IOException e) {
            MojangAuthentication.debug("Failed to write AuthInfo (failed to encode json) to file: " + profileFile.getAbsolutePath());
            e.printStackTrace();
            return false;
        }
    }

    private static void encodeJson(LinkedHashMap<String, Object> jsonData, JsonWriter writer) throws IOException {
        MojangAuthentication.encodeJsonObject(jsonData, writer);
    }

    private static void encodeJsonObject(LinkedHashMap<String, Object> jsonData, JsonWriter writer) throws IOException {
        writer.beginObject();
        for (Map.Entry<String, Object> entry : jsonData.entrySet()) {
            writer.name(entry.getKey());
            Object val = entry.getValue();
            if (val == null) {
                writer.nullValue();
                continue;
            }
            if (val instanceof LinkedHashMap) {
                MojangAuthentication.encodeJsonObject((LinkedHashMap)val, writer);
                continue;
            }
            if (val instanceof ArrayList) {
                MojangAuthentication.encodeJsonArray((ArrayList)val, writer);
                continue;
            }
            if (val instanceof Long) {
                writer.value((Number)((Long)val));
                continue;
            }
            if (val instanceof Double) {
                writer.value((Number)((Double)val));
                continue;
            }
            if (val instanceof Number) {
                writer.value((Number)val);
                continue;
            }
            if (val instanceof String) {
                writer.value((String)val);
                continue;
            }
            if (val instanceof Boolean) {
                writer.value((Boolean)val);
                continue;
            }
            MojangAuthentication.debug("Unsupported class found while encoding: " + val.getClass().getName());
        }
        writer.endObject();
    }

    private static void encodeJsonArray(ArrayList<Object> jsonData, JsonWriter writer) throws IOException {
        writer.beginArray();
        for (Object val : jsonData) {
            if (val == null) {
                writer.nullValue();
                continue;
            }
            if (val instanceof LinkedHashMap) {
                MojangAuthentication.encodeJsonObject((LinkedHashMap)val, writer);
                continue;
            }
            if (val instanceof ArrayList) {
                MojangAuthentication.encodeJsonArray((ArrayList)val, writer);
                continue;
            }
            if (val instanceof Long) {
                writer.value((Number)((Long)val));
                continue;
            }
            if (val instanceof Double) {
                writer.value((Number)((Double)val));
                continue;
            }
            if (val instanceof Number) {
                writer.value((Number)val);
                continue;
            }
            if (val instanceof String) {
                writer.value((String)val);
                continue;
            }
            if (val instanceof Boolean) {
                writer.value((Boolean)val);
                continue;
            }
            MojangAuthentication.debug("Unsupported class found while encoding: " + val.getClass().getName());
        }
        writer.endArray();
    }

    private static void debug(String message) {
        System.out.println("[" + MojangAuthentication.class.getName() + "] " + message);
    }
}

