/*
 * Decompiled with CFR 0.152.
 */
package sckioskmode.eventhandler;

import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import sckioskmode.gui.screen.TimeoutWarningScreen;

public class KioskModeLogoutTimer {
    private static final int INPUT_TIMEOUT_MS = 60000;
    private static final int POPUP_TIMEOUT_MS = 15000;
    private Timer timer = null;
    private long lastInteractionMs;
    private float lastRotationPitch = 0.0f;
    private float lastRotationYaw = 0.0f;
    private boolean hasBeenActivitySinceTimeoutPopup = false;
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;
    private boolean lastMouseGrabbed = false;
    private static final long ACTIVITY_CHECK_UPDATE_INITIAL_DELAY_MS = 1000L;
    private static final long ACTIVITY_CHECK_UPDATE_INTERVAL_MS = 1000L;
    private static final double MOUSE_ACTIVITY_MOVEMENT_THRESHOLD = 5.0;
    private static final double MOUSE_ACTIVITY_MOVEMENT_THRESHOLD_SQUARE = 25.0;

    @SubscribeEvent
    public void openGui(GuiOpenEvent event) {
        if (this.timer != null && Minecraft.func_71410_x().field_71441_e == null) {
            this.timer.cancel();
            this.timer = null;
            return;
        }
        if (this.timer == null && Minecraft.func_71410_x().field_71441_e != null && !(event.getGui() instanceof TimeoutWarningScreen)) {
            this.lastInteractionMs = System.currentTimeMillis();
            this.timer = new Timer(true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    Minecraft.func_71410_x().func_213167_f(() -> KioskModeLogoutTimer.this.onInterrupt());
                }
            }, 1000L, 1000L);
        }
    }

    private void onInterrupt() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        if (player == null) {
            this.timer.cancel();
            this.timer = null;
            this.hasBeenActivitySinceTimeoutPopup = false;
            return;
        }
        boolean mouseActivity = false;
        double mouseX = mc.field_71417_B.func_198024_e();
        double mouseY = mc.field_71417_B.func_198026_f();
        if (mc.field_71417_B.func_198035_h() != this.lastMouseGrabbed) {
            this.lastMouseGrabbed = mc.field_71417_B.func_198035_h();
            mouseActivity = true;
        } else if (!mc.field_71417_B.func_198035_h()) {
            double dx = mouseX - this.lastMouseX;
            double dy = mouseY - this.lastMouseY;
            mouseActivity = dx * dx + dy * dy >= 25.0;
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
        if (mouseActivity || player.func_226277_ct_() != player.field_70142_S || player.func_226278_cu_() != player.field_70137_T || player.func_226281_cx_() != player.field_70136_U || player.field_70125_A != this.lastRotationPitch || player.field_70177_z != this.lastRotationYaw) {
            this.lastInteractionMs = System.currentTimeMillis();
            this.hasBeenActivitySinceTimeoutPopup = true;
            this.lastRotationPitch = player.field_70125_A;
            this.lastRotationYaw = player.field_70177_z;
            return;
        }
        if (System.currentTimeMillis() - this.lastInteractionMs < 60000L || !this.hasBeenActivitySinceTimeoutPopup) {
            return;
        }
        this.timer.cancel();
        this.timer = null;
        mc.func_147108_a((Screen)new TimeoutWarningScreen(mc.field_71462_r, 15000));
        this.hasBeenActivitySinceTimeoutPopup = false;
    }
}

